<?php $__env->startSection('page-title', 'Tasks'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-800 rounded-lg shadow-xl border border-gray-700">
    <div class="px-6 py-4 border-b border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-white mb-4 sm:mb-0">
                <i class="fas fa-tasks mr-3 text-red-400"></i>
                Tasks
            </h1>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Task::class)): ?>
                <a href="<?php echo e(route('tasks.create')); ?>" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                    <i class="fas fa-plus mr-2"></i>Create Task
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="p-6">
        <?php if(session('success')): ?>
            <div class="mb-4 bg-green-900 border border-green-700 text-green-300 px-4 py-3 rounded-md">
                <div class="flex items-center">
                    <i class="fas fa-check-circle mr-2"></i>
                    <div><?php echo e(session('success')); ?></div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Enhanced Filters -->
        <div class="mb-6 bg-gray-700 rounded-lg border border-gray-600 p-4">
            <form method="GET" action="<?php echo e(route('tasks.index')); ?>" class="space-y-4">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-medium text-white">
                        <i class="fas fa-filter mr-2 text-red-400"></i>
                        Filters
                    </h3>
                    <button type="button" id="toggleFilters" class="text-gray-400 hover:text-white transition-colors duration-200">
                        <i class="fas fa-chevron-down" id="filterIcon"></i>
                    </button>
                </div>
                
                <div id="filterContent" class="space-y-4">
                    <!-- Search and Quick Filters Row -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <!-- Employee Name Search -->
                        <div>
                            <label for="employee_search" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-user mr-1"></i>
                                Employee Name
                            </label>
                            <input type="text" name="employee_search" id="employee_search" value="<?php echo e(request('employee_search')); ?>" placeholder="Search by employee name..."
                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <!-- Department Filter -->
                        <div>
                            <label for="department" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-building mr-1"></i>
                                Department
                            </label>
                            <select id="department" name="department" 
                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Departments</option>
                                <?php $__currentLoopData = \App\Models\Department::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($dept->id); ?>" <?php echo e(request('department') == $dept->id ? 'selected' : ''); ?>>
                                        <?php echo e($dept->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <!-- Status Filter -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-tasks mr-1"></i>
                                Status
                            </label>
                            <select id="status" name="status" 
                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Status</option>
                                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>>In Progress</option>
                                <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                            </select>
                        </div>
                        
                        <!-- Priority Filter -->
                        <div>
                            <label for="priority" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                Priority
                            </label>
                            <select id="priority" name="priority" 
                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Priorities</option>
                                <option value="low" <?php echo e(request('priority') == 'low' ? 'selected' : ''); ?>>Low</option>
                                <option value="medium" <?php echo e(request('priority') == 'medium' ? 'selected' : ''); ?>>Medium</option>
                                <option value="high" <?php echo e(request('priority') == 'high' ? 'selected' : ''); ?>>High</option>
                                <option value="urgent" <?php echo e(request('priority') == 'urgent' ? 'selected' : ''); ?>>Urgent</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Date Range and Task Type Row -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <!-- Date From -->
                        <div>
                            <label for="date_from" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-calendar mr-1"></i>
                                Date From
                            </label>
                            <input type="date" id="date_from" name="date_from" 
                                   value="<?php echo e(request('date_from')); ?>"
                                   class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <!-- Date To -->
                        <div>
                            <label for="date_to" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-calendar mr-1"></i>
                                Date To
                            </label>
                            <input type="date" id="date_to" name="date_to" 
                                   value="<?php echo e(request('date_to')); ?>"
                                   class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <!-- Task Type -->
                        <div>
                            <label for="task_type" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-sitemap mr-1"></i>
                                Task Type
                            </label>
                            <select id="task_type" name="task_type" 
                                    class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Tasks</option>
                                <option value="parent" <?php echo e(request('task_type') == 'parent' ? 'selected' : ''); ?>>Parent Tasks Only</option>
                                <option value="subtask" <?php echo e(request('task_type') == 'subtask' ? 'selected' : ''); ?>>Subtasks Only</option>
                                <option value="main" <?php echo e(request('task_type') == 'main' ? 'selected' : ''); ?>>Main Tasks Only</option>
                            </select>
                        </div>
                        
                        <!-- Overdue Filter -->
                        <div>
                            <label for="overdue" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-clock mr-1"></i>
                                Deadline Status
                            </label>
                            <select id="overdue" name="overdue" 
                                    class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Tasks</option>
                                <option value="overdue" <?php echo e(request('overdue') == 'overdue' ? 'selected' : ''); ?>>Overdue Only</option>
                                <option value="due_soon" <?php echo e(request('overdue') == 'due_soon' ? 'selected' : ''); ?>>Due Soon (≤2 days)</option>
                                <option value="no_deadline" <?php echo e(request('overdue') == 'no_deadline' ? 'selected' : ''); ?>>No Deadline</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="flex flex-wrap gap-3 pt-2">
                        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                             <i class="fas fa-search mr-2"></i>
                             Apply Filters
                         </button>
                        <a href="<?php echo e(route('tasks.index')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-times mr-2"></i>
                            Clear Filters
                        </a>
                        <div class="text-sm text-gray-400 flex items-center ml-auto">
                            <i class="fas fa-info-circle mr-1"></i>
                            Showing <?php echo e($tasks->count()); ?> of <?php echo e($tasks->total()); ?> tasks
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <?php if($tasks->count() > 0): ?>
            <div class="bg-gray-700 rounded-lg border border-gray-600 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-800">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Title</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Priority</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Deadline</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Department</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Assigned To</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-600">
                            <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-gray-600 transition-colors duration-200 <?php echo e($task->is_overdue ? 'bg-red-900/20' : ''); ?>">
                                     <td class="px-6 py-4 whitespace-nowrap text-sm text-white">
                                         <div class="flex items-center">
                                             <?php if($task->parent_id): ?>
                                                 <span class="text-gray-500 mr-2">└─</span>
                                                 <i class="fas fa-tasks text-red-400 mr-2" title="Subtask"></i>
                                             <?php else: ?>
                                                 <?php if($task->subtasks->count() > 0): ?>
                                                     <i class="fas fa-sitemap text-green-400 mr-2" title="Parent Task (<?php echo e($task->subtasks->count()); ?> subtasks)"></i>
                                                 <?php else: ?>
                                                     <i class="fas fa-task text-gray-400 mr-2" title="Main Task"></i>
                                                 <?php endif; ?>
                                             <?php endif; ?>
                                             <a href="<?php echo e(route('tasks.show', $task)); ?>" class="text-red-400 hover:text-red-300 transition-colors duration-200">
                                                 <?php echo e($task->title); ?>

                                                 <?php if($task->is_overdue): ?>
                                                     <i class="fas fa-exclamation-triangle text-red-400 ml-2" title="Overdue"></i>
                                                 <?php endif; ?>
                                             </a>
                                             <?php if($task->subtasks->count() > 0): ?>
                                                 <span class="ml-2 text-xs text-gray-400">(<?php echo e($task->subtasks->count()); ?> subtasks)</span>
                                             <?php endif; ?>
                                         </div>
                                     </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            <?php echo e($task->priority === 'urgent' ? 'bg-red-900 text-red-300' :
                        ($task->priority === 'high' ? 'bg-blue-900 text-blue-300' :
                        ($task->priority === 'medium' ? 'bg-yellow-900 text-yellow-300' : 'bg-green-900 text-green-300'))); ?>">
                                            <?php echo e(ucfirst($task->priority)); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                        <?php if($task->deadline): ?>
                                            <div class="<?php echo e($task->is_overdue ? 'text-blue-400' : ($task->daysUntilDeadline() <= 1 ? 'text-yellow-400' : 'text-gray-300')); ?>">
                                                <?php echo e($task->deadline->format('M d, Y H:i')); ?>

                                                <?php if($task->daysUntilDeadline() !== null): ?>
                                                    <br><small class="text-xs">
                                                        <?php if($task->is_overdue): ?>
                                                            <?php echo e(abs($task->daysUntilDeadline())); ?> days overdue
                                                        <?php else: ?>
                                                            <?php echo e($task->daysUntilDeadline()); ?> days left
                                                        <?php endif; ?>
                                                    </small>
                                                <?php endif; ?>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-gray-500">No deadline</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300"><?php echo e($task->currentDepartment->name ?? 'N/A'); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-white">
                                        <?php if($task->assignedTo): ?>
                                            <a href="<?php echo e(route('staff.show', $task->assignedTo)); ?>" class="text-red-400 hover:text-red-300 transition-colors duration-200">
                                                <?php echo e($task->assignedTo->name); ?>

                                            </a>
                                        <?php else: ?>
                                            <span class="text-gray-400">Unassigned</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            <?php echo e($task->status === 'completed' ? 'bg-blue-900 text-blue-300' : ($task->status === 'in_progress' ? 'bg-yellow-900 text-yellow-300' : 'bg-gray-900 text-gray-300')); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $task->status))); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex space-x-2">
                                            <a href="<?php echo e(route('tasks.show', $task)); ?>" class="bg-red-600 hover:bg-red-700 text-white px-3 py-1 rounded text-xs transition-colors duration-200">
                                                <i class="fas fa-eye mr-1"></i>
                                                View
                                            </a>
                                            <?php if(auth()->user()->role === 'admin' || auth()->user()->id === $task->assigned_to): ?>
                                                <a href="<?php echo e(route('tasks.edit', $task)); ?>" class="bg-yellow-600 hover:bg-yellow-700 text-white px-3 py-1 rounded text-xs transition-colors duration-200">
                                                    <i class="fas fa-edit mr-1"></i>
                                                    Edit
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        </table>
                </div>
            </div>

            <div class="mt-6 flex justify-center">
                <?php echo e($tasks->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12">
                <i class="fas fa-tasks text-6xl text-gray-500 mb-4"></i>
                <h3 class="text-xl font-medium text-gray-300 mb-2">No tasks found</h3>
                <p class="text-gray-400 mb-6">Get started by creating your first task.</p>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Task::class)): ?>
                    <a href="<?php echo e(route('tasks.create')); ?>" class="bg-red-600 hover:bg-red-700 text-white px-6 py-3 rounded-md font-medium transition-colors duration-200">
                        <i class="fas fa-plus mr-2"></i>Create First Task
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Toggle filter visibility
document.getElementById('toggleFilters').addEventListener('click', function() {
    const content = document.getElementById('filterContent');
    const icon = document.getElementById('filterIcon');
    
    if (content.style.display === 'none') {
        content.style.display = 'block';
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-up');
        localStorage.setItem('filtersExpanded', 'true');
    } else {
        content.style.display = 'none';
        icon.classList.remove('fa-chevron-up');
        icon.classList.add('fa-chevron-down');
        localStorage.setItem('filtersExpanded', 'false');
    }
});

// Restore filter state from localStorage
document.addEventListener('DOMContentLoaded', function() {
    const filtersExpanded = localStorage.getItem('filtersExpanded');
    const content = document.getElementById('filterContent');
    const icon = document.getElementById('filterIcon');
    
    if (filtersExpanded === 'false') {
        content.style.display = 'none';
        icon.classList.remove('fa-chevron-up');
        icon.classList.add('fa-chevron-down');
    } else {
        content.style.display = 'block';
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-up');
    }
    
    // Auto-submit form on filter change for better UX
    const filterInputs = document.querySelectorAll('#filterContent select, #filterContent input[type="date"]');
    filterInputs.forEach(input => {
        input.addEventListener('change', function() {
            // Small delay to allow user to make multiple selections
            setTimeout(() => {
                this.closest('form').submit();
            }, 300);
        });
    });
    
    // Real-time search for employee name
    const employeeSearch = document.getElementById('employee_search');
    let searchTimeout;
    employeeSearch.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            this.closest('form').submit();
        }, 500); // Wait 500ms after user stops typing
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\StaffApp\Nitin App\resources\views/tasks/index.blade.php ENDPATH**/ ?>