<div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
    <h2 class="text-lg font-medium text-gray-900 dark:text-white">
        <i class="fas fa-table mr-2 text-red-600 dark:text-red-400"></i>
        Stock Inventory
    </h2>
</div>

<?php if($stocks->count() > 0): ?>
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 dark:bg-gray-800">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Product</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Style</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Color</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Size</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Batch No</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Balance Qty</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Uploaded</th>
                </tr>
            </thead>
            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-600">
                <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white"><?php echo e($stock->name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300"><?php echo e($stock->product); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300"><?php echo e($stock->style); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300"><?php echo e($stock->color); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300"><?php echo e($stock->size); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300"><?php echo e($stock->batch_no); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                <?php if($stock->current_balance_qty > 10): ?> bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200
                                <?php elseif($stock->current_balance_qty > 5): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200
                                <?php else: ?> bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200 <?php endif; ?>">
                                <?php echo e($stock->current_balance_qty); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                            <div class="flex flex-col">
                                <span class="text-xs text-gray-700 dark:text-gray-300"><?php echo e($stock->uploaded_by ?? 'Admin User'); ?></span>
                                <span class="text-xs text-gray-500 dark:text-gray-500"><?php echo e($stock->created_at->format('M d, Y H:i')); ?></span>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if($stocks->hasPages()): ?>
        <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-600">
            <div class="flex items-center justify-between">
                <div class="text-sm text-gray-500 dark:text-gray-400">
                    Showing <?php echo e($stocks->firstItem() ?? 0); ?> to <?php echo e($stocks->lastItem() ?? 0); ?> of <?php echo e($stocks->total()); ?> results
                </div>
                <div class="flex space-x-2">
                    <?php echo e($stocks->appends(request()->query())->links('pagination::tailwind')); ?>

                </div>
            </div>
        </div>
    <?php endif; ?>
<?php else: ?>
    <div class="text-center py-12">
        <i class="fas fa-inbox text-gray-400 dark:text-gray-500 text-6xl mb-4"></i>
        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-400 mb-2">No Stock Found</h3>
        <p class="text-gray-500 dark:text-gray-500">No stock items match your current filters.</p>
    </div>
<?php endif; ?><?php /**PATH C:\StaffApp\HRApp\resources\views/stock/partials/table.blade.php ENDPATH**/ ?>