<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-white">Edit Payroll</h1>
                        <p class="mt-1 text-sm text-gray-300"><?php echo e($payroll->user->name); ?> - <?php echo e(date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?></p>
                    </div>
                    <a href="<?php echo e(route('payrolls.show', $payroll)); ?>" class="inline-flex items-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to Details
                    </a>
                </div>
            </div>
        </div>

        <!-- Error Messages -->
        <?php if($errors->any()): ?>
            <div class="bg-red-900 bg-opacity-20 border border-red-700 text-red-400 px-4 py-3 rounded-lg mb-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-circle"></i>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium">There were some errors with your submission:</h3>
                        <ul class="mt-2 text-sm list-disc list-inside">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('payrolls.update', $payroll)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Form -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Employee Information -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Employee Information</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Employee</label>
                                    <p class="mt-1 text-sm text-white bg-gray-700 px-3 py-2 rounded-md border border-gray-600"><?php echo e($payroll->user->name); ?></p>
                                    <input type="hidden" name="user_id" value="<?php echo e($payroll->user_id); ?>">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Employee ID</label>
                                    <p class="mt-1 text-sm text-white bg-gray-700 px-3 py-2 rounded-md border border-gray-600"><?php echo e($payroll->user->staffProfile->employee_id ?? 'N/A'); ?></p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Department</label>
                                    <p class="mt-1 text-sm text-white bg-gray-700 px-3 py-2 rounded-md border border-gray-600"><?php echo e($payroll->user->staffProfile->department->name ?? 'No Department'); ?></p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Position</label>
                                    <p class="mt-1 text-sm text-white bg-gray-700 px-3 py-2 rounded-md border border-gray-600"><?php echo e($payroll->user->staffProfile->position ?? 'N/A'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Pay Period -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Pay Period</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="month" class="block text-sm font-medium text-gray-300">Month</label>
                                    <select name="month" id="month" class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                        <?php for($i = 1; $i <= 12; $i++): ?>
                                            <option value="<?php echo e($i); ?>" <?php echo e($payroll->month == $i ? 'selected' : ''); ?>>
                                                <?php echo e(date('F', mktime(0, 0, 0, $i, 1))); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                    <?php $__errorArgs = ['month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label for="year" class="block text-sm font-medium text-gray-300">Year</label>
                                    <select name="year" id="year" class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                        <?php for($i = date('Y') - 2; $i <= date('Y') + 1; $i++): ?>
                                            <option value="<?php echo e($i); ?>" <?php echo e($payroll->year == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                    <?php $__errorArgs = ['year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Work Details -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Work Details</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="days_worked" class="block text-sm font-medium text-gray-300">Days Worked</label>
                                    <input type="number" name="days_worked" id="days_worked" min="0" max="31" step="0.5" value="<?php echo e(old('days_worked', $payroll->days_worked)); ?>" class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                    <?php $__errorArgs = ['days_worked'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label for="hours_worked" class="block text-sm font-medium text-gray-300">Hours Worked</label>
                                    <input type="number" name="hours_worked" id="hours_worked" min="0" step="0.5" value="<?php echo e(old('hours_worked', $payroll->hours_worked)); ?>" class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                    <?php $__errorArgs = ['hours_worked'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Salary Details -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Salary Details</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="basic_salary" class="block text-sm font-medium text-gray-300">Basic Salary</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="basic_salary" id="basic_salary" min="0" step="0.01" value="<?php echo e(old('basic_salary', $payroll->basic_salary)); ?>" class="block w-full pl-7 bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="0.00">
                                    </div>
                                    <?php $__errorArgs = ['basic_salary'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label for="allowances" class="block text-sm font-medium text-gray-300">Allowances</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="allowances" id="allowances" min="0" step="0.01" value="<?php echo e(old('allowances', $payroll->allowances)); ?>" class="block w-full pl-7 bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="0.00">
                                    </div>
                                    <?php $__errorArgs = ['allowances'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label for="bonus" class="block text-sm font-medium text-gray-300">Bonus</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="bonus" id="bonus" min="0" step="0.01" value="<?php echo e(old('bonus', $payroll->bonus)); ?>" class="block w-full pl-7 bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="0.00">
                                    </div>
                                    <?php $__errorArgs = ['bonus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label for="deductions" class="block text-sm font-medium text-gray-300">Deductions</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="deductions" id="deductions" min="0" step="0.01" value="<?php echo e(old('deductions', $payroll->deductions)); ?>" class="block w-full pl-7 bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="0.00">
                                    </div>
                                    <?php $__errorArgs = ['deductions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Overtime Details -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Overtime Details</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <div>
                                    <label for="overtime_hours" class="block text-sm font-medium text-gray-300">Overtime Hours</label>
                                    <input type="number" name="overtime_hours" id="overtime_hours" min="0" step="0.5" value="<?php echo e(old('overtime_hours', $payroll->overtime_hours)); ?>" class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="0">
                                    <?php $__errorArgs = ['overtime_hours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label for="overtime_rate" class="block text-sm font-medium text-gray-300">Overtime Rate (per hour)</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="overtime_rate" id="overtime_rate" min="0" step="0.01" value="<?php echo e(old('overtime_rate', $payroll->overtime_rate)); ?>" class="block w-full pl-7 bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500" placeholder="0.00">
                                    </div>
                                    <?php $__errorArgs = ['overtime_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label for="overtime_pay" class="block text-sm font-medium text-gray-300">Overtime Pay (Auto-calculated)</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="overtime_pay" id="overtime_pay" min="0" step="0.01" value="<?php echo e(old('overtime_pay', $payroll->overtime_pay)); ?>" class="block w-full pl-7 bg-gray-600 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-400" placeholder="0.00" readonly>
                                    </div>
                                    <?php $__errorArgs = ['overtime_pay'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Status -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Status</h3>
                            
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-300">Payroll Status</label>
                                <select name="status" id="status" class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                    <option value="pending" <?php echo e($payroll->status === 'pending' ? 'selected' : ''); ?>>Pending</option>
                                    <option value="approved" <?php echo e($payroll->status === 'approved' ? 'selected' : ''); ?>>Approved</option>
                                    <option value="paid" <?php echo e($payroll->status === 'paid' ? 'selected' : ''); ?>>Paid</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <!-- Calculated Totals -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Calculated Totals</h3>
                            
                            <div class="space-y-4">
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-300">Gross Salary:</span>
                                    <span class="text-sm font-medium text-white" id="gross-total">₹<?php echo e(number_format($payroll->gross_salary, 2)); ?></span>
                                </div>
                                <div class="flex justify-between border-t border-gray-700 pt-4">
                                    <span class="text-sm font-medium text-white">Net Salary:</span>
                                    <span class="text-sm font-bold text-green-400" id="net-total">₹<?php echo e(number_format($payroll->net_salary, 2)); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <div class="space-y-3">
                                <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                    <i class="fas fa-save mr-2"></i>
                                    Update Payroll
                                </button>
                                <a href="<?php echo e(route('payrolls.show', $payroll)); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                    <i class="fas fa-times mr-2"></i>
                                    Cancel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
// Auto-calculate overtime pay
document.addEventListener('DOMContentLoaded', function() {
    const overtimeHours = document.getElementById('overtime_hours');
    const overtimeRate = document.getElementById('overtime_rate');
    const overtimePay = document.getElementById('overtime_pay');
    
    function calculateOvertimePay() {
        const hours = parseFloat(overtimeHours.value) || 0;
        const rate = parseFloat(overtimeRate.value) || 0;
        const pay = hours * rate;
        overtimePay.value = pay.toFixed(2);
        calculateTotals();
    }
    
    function calculateTotals() {
        const basicSalary = parseFloat(document.getElementById('basic_salary').value) || 0;
        const allowances = parseFloat(document.getElementById('allowances').value) || 0;
        const bonus = parseFloat(document.getElementById('bonus').value) || 0;
        const overtimePayValue = parseFloat(document.getElementById('overtime_pay').value) || 0;
        const deductions = parseFloat(document.getElementById('deductions').value) || 0;
        
        const grossSalary = basicSalary + allowances + bonus + overtimePayValue;
        const netSalary = grossSalary - deductions;
        
        document.getElementById('gross-total').textContent = '$' + grossSalary.toFixed(2);
        document.getElementById('net-total').textContent = '$' + netSalary.toFixed(2);
    }
    
    overtimeHours.addEventListener('input', calculateOvertimePay);
    overtimeRate.addEventListener('input', calculateOvertimePay);
    
    // Recalculate totals when other fields change
    ['basic_salary', 'allowances', 'bonus', 'deductions'].forEach(function(fieldId) {
        document.getElementById(fieldId).addEventListener('input', calculateTotals);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/payroll/edit.blade.php ENDPATH**/ ?>