<?php $__env->startSection('title', 'Staff Dashboard - Staff Management System'); ?>
<?php $__env->startSection('page-title', 'My Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Task Priority Section -->
    <div class="bg-gradient-to-r from-red-600 to-red-700 shadow-xl rounded-lg border border-red-500">
        <div class="px-6 py-8">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-white mb-2">Welcome back, <?php echo e(Auth::user()->name); ?>!</h1>
                    <p class="text-red-100">Department: <span class="font-semibold"><?php echo e($stats['department']); ?></span></p>
                </div>
                <div class="flex space-x-3">
                    <a href="<?php echo e(route('tasks.index')); ?>" class="inline-flex items-center px-4 py-2 bg-white text-red-600 font-semibold rounded-lg hover:bg-red-50 transition-colors">
                        <i class="fas fa-list mr-2"></i>
                        All Tasks
                    </a>
                </div>
            </div>
            
            <!-- Task Stats -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-white bg-opacity-10 backdrop-blur-sm rounded-lg p-4">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-tasks text-3xl text-yellow-300"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-red-100 text-sm font-medium">Assigned Tasks</p>
                            <p class="text-white text-2xl font-bold"><?php echo e($stats['assigned_tasks']); ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white bg-opacity-10 backdrop-blur-sm rounded-lg p-4">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-check-circle text-3xl text-green-300"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-red-100 text-sm font-medium">Completed Tasks</p>
                            <p class="text-white text-2xl font-bold"><?php echo e($stats['completed_tasks']); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- My Tasks (Expanded) -->
    <div class="bg-gray-800 shadow-xl rounded-lg border border-gray-700">
        <div class="px-6 py-5">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-white">My Tasks</h3>
                <a href="<?php echo e(route('tasks.index')); ?>" class="text-sm text-red-400 hover:text-red-300 font-medium">View all tasks →</a>
            </div>
            <div class="space-y-4">
                <?php $__empty_1 = true; $__currentLoopData = $my_tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="flex items-center justify-between p-4 bg-gray-700 rounded-lg hover:bg-gray-600 transition-colors">
                        <div class="flex-1">
                            <h4 class="text-base font-medium text-white mb-1"><?php echo e($task->title); ?></h4>
                            <?php if($task->description): ?>
                                <p class="text-sm text-gray-300 mb-2"><?php echo e(Str::limit($task->description, 80)); ?></p>
                            <?php endif; ?>
                            <div class="flex items-center space-x-4 text-xs text-gray-400">
                                <span><i class="fas fa-user mr-1"></i><?php echo e($task->creator->name); ?></span>
                                <span><i class="fas fa-building mr-1"></i><?php echo e($task->currentDepartment->name); ?></span>
                                <span><i class="fas fa-calendar mr-1"></i><?php echo e($task->created_at->diffForHumans()); ?></span>
                            </div>
                        </div>
                        <div class="flex items-center space-x-3">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                                <?php if($task->status === 'pending'): ?> bg-yellow-900 text-yellow-300
                                <?php elseif($task->status === 'in_progress'): ?> bg-blue-900 text-blue-300
                                <?php else: ?> bg-green-900 text-green-300 <?php endif; ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $task->status))); ?>

                            </span>
                            <?php if($task->status !== 'completed'): ?>
                                <a href="<?php echo e(route('tasks.show', $task)); ?>" class="text-red-400 hover:text-red-300">
                                    <i class="fas fa-arrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-8">
                        <i class="fas fa-tasks text-4xl text-gray-600 mb-4"></i>
                        <p class="text-gray-400 text-lg">No tasks assigned yet</p>
                        <p class="text-gray-500 text-sm">Check back later for new assignments</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-gray-800 overflow-hidden shadow rounded-lg border border-gray-700">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-calendar-check text-2xl text-red-400"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-400 truncate">Days Present</dt>
                            <dd class="text-lg font-medium text-white"><?php echo e($stats['attendance_this_month']); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-gray-800 overflow-hidden shadow rounded-lg border border-gray-700">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-building text-2xl text-red-400"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-400 truncate">Department</dt>
                            <dd class="text-sm font-medium text-white"><?php echo e($stats['department']); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-1 gap-6">

        <!-- Recent Attendance -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg leading-6 font-medium text-white">Recent Attendance</h3>
                    <a href="<?php echo e(route('attendance.staff')); ?>" class="text-sm text-red-400 hover:text-red-300">View all</a>
                </div>
                <div class="space-y-3">
                    <?php $__empty_1 = true; $__currentLoopData = $recent_attendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="flex items-center justify-between p-3 bg-gray-700 rounded-lg">
                            <div>
                                <p class="text-sm font-medium text-white"><?php echo e($attendance->date->format('M d, Y')); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e($attendance->date->format('l')); ?></p>
                            </div>
                            <div>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                    <?php if($attendance->status === 'present'): ?> bg-red-900 text-red-300
                                    <?php else: ?> bg-red-900 text-red-300 <?php endif; ?>">
                                    <i class="fas fa-<?php echo e($attendance->status === 'present' ? 'check' : 'times'); ?> mr-1"></i>
                                    <?php echo e(ucfirst($attendance->status)); ?>

                                </span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center py-8">
                            <i class="fas fa-calendar-check text-4xl text-gray-500 mb-4"></i>
                            <p class="text-sm text-gray-400">No attendance records yet</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
        <div class="px-4 py-5 sm:p-6">
            <h3 class="text-lg leading-6 font-medium text-white mb-4">Quick Actions</h3>
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                <a href="<?php echo e(route('tasks.index')); ?>" class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                    <i class="fas fa-tasks mr-2"></i>
                    View My Tasks
                </a>
                <a href="<?php echo e(route('attendance.staff')); ?>" class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                    <i class="fas fa-calendar-alt mr-2"></i>
                    View Attendance
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\StaffApp\Nitin App\resources\views/dashboard/staff.blade.php ENDPATH**/ ?>