<?php $__env->startSection('title', 'Admin Dashboard - Staff Management System'); ?>
<?php $__env->startSection('page-title', 'Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <!-- Welcome Header -->
    <div class="bg-gradient-to-r from-red-600 to-orange-700 dark:from-gray-800/50 dark:to-gray-800/50 dark:bg-gray-800/50 dark:backdrop-blur-md shadow-lg rounded-lg border border-red-500/30 dark:border-gray-700 transition-all duration-300">
        <div class="px-6 py-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-white dark:text-white mb-2">
                        Welcome Back, Admin! 👋
                    </h1>
                    <p class="text-red-100 dark:text-gray-300">Here's what's happening with your team today</p>
                </div>
                <div class="flex space-x-3">
                    <a href="<?php echo e(route('tasks.create')); ?>" class="inline-flex items-center px-4 py-2 bg-white dark:bg-gray-700 text-red-600 dark:text-white font-medium rounded-lg hover:bg-red-50 dark:hover:bg-gray-600 transition-colors shadow-sm">
                        <i class="fas fa-plus mr-2"></i>
                        New Task
                    </a>
                    <a href="<?php echo e(route('tasks.index')); ?>" class="inline-flex items-center px-4 py-2 bg-red-800 dark:bg-red-900/50 text-white font-medium rounded-lg hover:bg-red-900 dark:hover:bg-red-900 transition-colors border border-transparent dark:border-red-800">
                        <i class="fas fa-list mr-2"></i>
                        View All
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Task Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-5 gap-6">
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-yellow-100 dark:bg-yellow-900/20 rounded-lg">
                        <i class="fas fa-clock text-2xl text-yellow-600 dark:text-yellow-400"></i>
                    </div>
                    <div class="ml-3 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Pending Tasks</dt>
                            <dd class="text-lg font-medium text-gray-900 dark:text-white"><?php echo e($stats['pending_tasks']); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-orange-100 dark:bg-orange-900/20 rounded-lg">
                        <i class="fas fa-spinner text-2xl text-orange-600 dark:text-orange-400"></i>
                    </div>
                    <div class="ml-3 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">In Progress</dt>
                            <dd class="text-lg font-medium text-gray-900 dark:text-white"><?php echo e($stats['in_progress_tasks']); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-green-100 dark:bg-green-900/20 rounded-lg">
                        <i class="fas fa-check-circle text-2xl text-green-600 dark:text-green-400"></i>
                    </div>
                    <div class="ml-3 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Completed</dt>
                            <dd class="text-lg font-medium text-gray-900 dark:text-white"><?php echo e($stats['completed_tasks']); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-red-100 dark:bg-red-900/20 rounded-lg">
                        <i class="fas fa-exclamation-triangle text-2xl text-red-600 dark:text-red-400"></i>
                    </div>
                    <div class="ml-3 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Overdue</dt>
                            <dd class="text-lg font-medium text-gray-900 dark:text-white"><?php echo e($stats['overdue_tasks'] ?? 0); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-orange-100 dark:bg-orange-900/20 rounded-lg">
                        <i class="fas fa-hourglass-half text-2xl text-orange-600 dark:text-orange-400"></i>
                    </div>
                    <div class="ml-3 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Due Soon</dt>
                            <dd class="text-lg font-medium text-gray-900 dark:text-white"><?php echo e($stats['due_soon_tasks'] ?? 0); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Tasks (Expanded) -->
    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow-xl rounded-2xl border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="bg-gray-50 dark:bg-gray-800/50 px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between mb-2">
                <div class="flex items-center">
                    <div class="p-2 bg-red-100 dark:bg-red-600/20 rounded-lg mr-4">
                        <i class="fas fa-tasks text-red-600 dark:text-red-400 text-xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Recent Tasks</h3>
                </div>
                <a href="<?php echo e(route('tasks.index')); ?>" class="inline-flex items-center text-sm text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 font-medium bg-red-100 dark:bg-red-600/10 px-4 py-2 rounded-lg hover:bg-red-200 dark:hover:bg-red-600/20 transition-all duration-200">
                    View all tasks
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
        <div class="px-8 py-6">
            <div class="space-y-4">
                <?php $__empty_1 = true; $__currentLoopData = $recent_tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-600/50 transition-colors">
                        <div class="flex-1">
                            <h4 class="text-base font-medium text-gray-900 dark:text-white mb-1"><?php echo e($task->title); ?></h4>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mb-2"><?php echo e(Str::limit($task->description, 80)); ?></p>
                            <div class="flex items-center space-x-4 text-xs text-gray-500 dark:text-gray-400">
                                <span><i class="fas fa-user mr-1"></i><?php echo e($task->creator->name); ?></span>
                                <span><i class="fas fa-building mr-1"></i><?php echo e($task->currentDepartment->name); ?></span>
                                <?php if($task->currentAssignee): ?>
                                    <span><i class="fas fa-user-tag mr-1"></i><?php echo e($task->currentAssignee->name); ?></span>
                                <?php endif; ?>
                                <span><i class="fas fa-calendar mr-1"></i><?php echo e($task->created_at->diffForHumans()); ?></span>
                            </div>
                        </div>
                        <div class="flex items-center space-x-3">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                                <?php if($task->status === 'pending'): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300
                                <?php elseif($task->status === 'in_progress'): ?> bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300
                                <?php else: ?> bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300 <?php endif; ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $task->status))); ?>

                            </span>
                            <a href="<?php echo e(route('tasks.show', $task)); ?>" class="text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300">
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-8">
                        <i class="fas fa-tasks text-4xl text-gray-400 dark:text-gray-600 mb-4"></i>
                        <p class="text-gray-500 dark:text-gray-400 text-lg">No recent tasks</p>
                        <p class="text-gray-500 dark:text-gray-500 text-sm">Create your first task to get started</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        <div class="group bg-gradient-to-br from-red-50 to-orange-50 dark:from-red-600/10 dark:to-orange-600/10 backdrop-blur-sm overflow-hidden shadow-xl rounded-2xl border border-red-200 dark:border-red-500/30 hover:border-red-300 dark:hover:border-red-400/60 transition-all duration-300 hover:scale-105">
            <div class="p-8">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-4 bg-red-100 dark:bg-red-500/20 rounded-2xl mr-6">
                            <i class="fas fa-users text-3xl text-red-500 dark:text-red-400"></i>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-red-600 dark:text-red-200 mb-1">Total Staff</dt>
                            <dd class="text-3xl font-bold text-gray-900 dark:text-white"><?php echo e($stats['total_staff']); ?></dd>
                        </div>
                    </div>
                    <div class="text-red-400/60">
                        <i class="fas fa-chart-line text-2xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-8">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-4 bg-gray-100 dark:bg-red-500/20 rounded-2xl mr-6">
                            <i class="fas fa-building text-3xl text-gray-500 dark:text-red-400"></i>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-red-200 mb-1">Departments</dt>
                            <dd class="text-3xl font-bold text-gray-900 dark:text-white"><?php echo e($stats['total_departments']); ?></dd>
                        </div>
                    </div>
                    <div class="text-gray-400 dark:text-red-400/60">
                        <i class="fas fa-sitemap text-2xl"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="group bg-gradient-to-br from-green-50 to-emerald-50 dark:from-green-600/10 dark:to-emerald-600/10 backdrop-blur-sm overflow-hidden shadow-xl rounded-2xl border border-green-200 dark:border-green-500/30 hover:border-green-300 dark:hover:border-green-400/60 transition-all duration-300 hover:scale-105">
            <div class="p-8">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-4 bg-green-100 dark:bg-green-500/20 rounded-2xl mr-6">
                            <i class="fas fa-calendar-check text-3xl text-green-500 dark:text-green-400"></i>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-green-600 dark:text-green-200 mb-1">Present Today</dt>
                            <dd class="text-3xl font-bold text-gray-900 dark:text-white"><?php echo e($stats['present_today']); ?></dd>
                        </div>
                    </div>
                    <div class="text-green-400/60">
                        <i class="fas fa-user-check text-2xl"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-1 gap-6">

        <!-- Department Overview -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow-2xl rounded-2xl border border-gray-200 dark:border-gray-600/50 overflow-hidden">
            <div class="bg-gray-50 dark:bg-gray-800/50 px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-2 bg-red-100 dark:bg-red-600/20 rounded-lg mr-4">
                        <i class="fas fa-sitemap text-red-500 dark:text-red-400 text-xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Department Overview</h3>
                    </div>
                    <a href="<?php echo e(route('staff.index')); ?>" class="inline-flex items-center text-sm text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 font-medium bg-red-100 dark:bg-red-600/10 px-4 py-2 rounded-lg hover:bg-red-200 dark:hover:bg-red-600/20 transition-all duration-200">
                        Manage staff
                        <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
            </div>
            <div class="px-8 py-6">
                <div class="space-y-3">
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                            <div>
                                <p class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($department->name); ?></p>
                                <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo e($department->staff_profiles_count); ?> staff members</p>
                            </div>
                            <div class="text-right">
                                <div class="w-16 bg-gray-200 dark:bg-gray-600 rounded-full h-2">
                                    <div class="bg-red-500 h-2 rounded-full" style="width: <?php echo e(min(100, ($department->staff_profiles_count / max(1, $stats['total_staff'])) * 100)); ?>%"></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow-2xl rounded-2xl border border-gray-200 dark:border-gray-600/50 overflow-hidden">
        <div class="bg-gradient-to-r from-emerald-50 to-teal-50 dark:from-emerald-600/10 dark:to-teal-600/10 px-8 py-6 border-b border-gray-200 dark:border-gray-600/50">
            <div class="flex items-center">
                <div class="p-2 bg-emerald-100 dark:bg-emerald-600/20 rounded-lg mr-4">
                    <i class="fas fa-bolt text-emerald-500 dark:text-emerald-400 text-xl"></i>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Quick Actions</h3>
            </div>
        </div>
        <div class="px-8 py-8">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <a href="<?php echo e(route('staff.create')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-red-50 to-orange-50 dark:from-red-600/20 dark:to-orange-600/20 backdrop-blur-sm border border-red-200 dark:border-red-500/30 hover:border-red-300 dark:hover:border-red-400/60 rounded-2xl p-6 transition-all duration-300 hover:scale-105 hover:shadow-xl">
                    <div class="flex flex-col items-center text-center">
                        <div class="p-4 bg-red-100 dark:bg-red-500/20 rounded-2xl mb-4 group-hover:scale-110 transition-transform duration-300">
                            <i class="fas fa-user-plus text-3xl text-red-500 dark:text-red-400"></i>
                        </div>
                        <span class="text-gray-900 dark:text-white font-semibold text-lg">Add New Staff</span>
                        <span class="text-red-600 dark:text-red-200 text-sm mt-1">Create staff profile</span>
                    </div>
                </a>
                
                <a href="<?php echo e(route('tasks.create')); ?>" class="block bg-gray-50 dark:bg-gray-700/50 hover:bg-gray-100 dark:hover:bg-gray-600/50 border border-gray-200 dark:border-gray-600 rounded-lg p-6 transition-colors">
                    <div class="flex flex-col items-center text-center">
                        <div class="p-4 bg-red-100 dark:bg-red-500/20 rounded-2xl mb-4">
                             <i class="fas fa-plus text-3xl text-red-500 dark:text-red-400"></i>
                        </div>
                        <span class="text-gray-900 dark:text-white font-semibold text-lg">Create Task</span>
                        <span class="text-red-600 dark:text-red-200 text-sm mt-1">Assign new task</span>
                    </div>
                </a>
                
                <a href="<?php echo e(route('attendance.index')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-green-50 to-emerald-50 dark:from-green-600/20 dark:to-emerald-600/20 backdrop-blur-sm border border-green-200 dark:border-green-500/30 hover:border-green-300 dark:hover:border-green-400/60 rounded-2xl p-6 transition-all duration-300 hover:scale-105 hover:shadow-xl">
                    <div class="flex flex-col items-center text-center">
                        <div class="p-4 bg-green-100 dark:bg-green-500/20 rounded-2xl mb-4 group-hover:scale-110 transition-transform duration-300">
                            <i class="fas fa-calendar-check text-3xl text-green-500 dark:text-green-400"></i>
                        </div>
                        <span class="text-gray-900 dark:text-white font-semibold text-lg">Mark Attendance</span>
                        <span class="text-green-600 dark:text-green-200 text-sm mt-1">Track presence</span>
                    </div>
                </a>
                
                <a href="<?php echo e(route('payrolls.index')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-yellow-50 to-orange-50 dark:from-yellow-600/20 dark:to-orange-600/20 backdrop-blur-sm border border-yellow-200 dark:border-yellow-500/30 hover:border-yellow-300 dark:hover:border-yellow-400/60 rounded-2xl p-6 transition-all duration-300 hover:scale-105 hover:shadow-xl">
                    <div class="flex flex-col items-center text-center">
                        <div class="p-4 bg-yellow-100 dark:bg-yellow-500/20 rounded-2xl mb-4 group-hover:scale-110 transition-transform duration-300">
                            <i class="fas fa-money-bill-wave text-3xl text-yellow-500 dark:text-yellow-400"></i>
                        </div>
                        <span class="text-gray-900 dark:text-white font-semibold text-lg">View Payroll</span>
                        <span class="text-yellow-600 dark:text-yellow-200 text-sm mt-1">Manage payments</span>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yavis/hr/resources/views/dashboard/admin.blade.php ENDPATH**/ ?>