

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 dark:bg-transparent py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Payroll Details</h1>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300"><?php echo e($payroll->user->name); ?> - <?php echo e(date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?></p>
                    </div>
                    <div class="flex space-x-3">
                        <a href="<?php echo e(route('payrolls.index')); ?>" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700/50 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to List
                        </a>
                        <a href="<?php echo e(route('payrolls.downloadPdf', $payroll)); ?>" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            <i class="fas fa-file-pdf mr-2"></i>
                            Download Payslip
                        </a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $payroll)): ?>
                            <a href="<?php echo e(route('payrolls.edit', $payroll)); ?>" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-edit mr-2"></i>
                                Edit
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Employee Information -->
            <div class="lg:col-span-2">
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Employee Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Employee Name</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->user->name); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Employee ID</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->user->staffProfile->employee_id ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Department</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->user->staffProfile->department->name ?? 'No Department'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Position</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->user->staffProfile->position ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Email</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->user->email); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Phone</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->user->staffProfile->phone ?? 'N/A'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payroll Details -->
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Payroll Breakdown</h3>
                        
                        <div class="space-y-6">
                            <!-- Basic Information -->
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Pay Period</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e(date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?></p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Days Worked</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->days_worked ?? 0); ?> days</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Days Present</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->days_present ?? 0); ?> days</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Days Absent</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->days_absent ?? 0); ?> days</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Total Work Days</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white"><?php echo e($payroll->total_work_days ?? 0); ?> days</p>
                                </div>
                            </div>

                            <!-- Earnings -->
                            <div>
                                <h4 class="text-md font-medium text-gray-900 dark:text-white mb-4">Earnings</h4>
                                <div class="bg-gray-50 dark:bg-gray-700 p-4 rounded-md border border-gray-200 dark:border-gray-600">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <?php if($payroll->basic_salary > 0 || $payroll->hra > 0): ?>
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Basic Salary:</span>
                                                <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->basic_salary, 2)); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">HRA:</span>
                                                <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->hra, 2)); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Conveyance:</span>
                                                <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->conveyance, 2)); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Special Allowance:</span>
                                                <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->special_allowance, 2)); ?></span>
                                            </div>
                                            <div class="col-span-1 md:col-span-2 border-t border-gray-200 dark:border-gray-600 my-2"></div>
                                            <div class="flex justify-between font-bold">
                                                <span class="text-sm text-gray-900 dark:text-white">Gross Salary:</span>
                                                <span class="text-sm text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->gross_salary, 2)); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <!-- Legacy Display -->
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Monthly Compensation:</span>
                                                <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->monthly_compensation, 2)); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <div class="col-span-1 md:col-span-2 border-t border-gray-200 dark:border-gray-600 my-2"></div>

                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-500 dark:text-gray-300">Daily Rate:</span>
                                            <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->daily_rate ?? 0, 2)); ?></span>
                                        </div>
                                        <div class="flex justify-between font-bold text-lg">
                                            <span class="text-sm text-green-600 dark:text-green-400">Total Payout:</span>
                                            <span class="text-sm text-green-600 dark:text-green-400">₹<?php echo e(number_format($payroll->total_payout ?? 0, 2)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Detailed Breakdown (if available) -->
                            <?php if($payroll->ctc > 0): ?>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Employer Contributions -->
                                <div>
                                    <h4 class="text-md font-medium text-gray-900 dark:text-white mb-4">Employer Contributions</h4>
                                    <div class="bg-gray-50 dark:bg-gray-700/50 p-4 rounded-md border border-gray-200 dark:border-gray-600 h-full">
                                        <div class="space-y-2">
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Employer PF:</span>
                                                <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->employer_pf, 2)); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Employer ESI:</span>
                                                <span class="text-sm font-medium text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->employer_esi, 2)); ?></span>
                                            </div>
                                            <div class="border-t border-gray-200 dark:border-gray-600 my-2 pt-2">
                                                <div class="flex justify-between font-bold">
                                                    <span class="text-sm text-gray-900 dark:text-white">CTC:</span>
                                                    <span class="text-sm text-gray-900 dark:text-white">₹<?php echo e(number_format($payroll->ctc, 2)); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Employee Deductions -->
                                <div>
                                    <h4 class="text-md font-medium text-gray-900 dark:text-white mb-4">Employee Deductions</h4>
                                    <div class="bg-red-50 dark:bg-red-900/20 p-4 rounded-md border border-red-200 dark:border-red-700 h-full">
                                        <div class="space-y-2">
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Employee PF:</span>
                                                <span class="text-sm font-medium text-red-600 dark:text-red-300">-₹<?php echo e(number_format($payroll->employee_pf, 2)); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Employee ESI:</span>
                                                <span class="text-sm font-medium text-red-600 dark:text-red-300">-₹<?php echo e(number_format($payroll->employee_esi, 2)); ?></span>
                                            </div>
                                            <div class="flex justify-between">
                                                <span class="text-sm text-gray-500 dark:text-gray-300">Professional Tax:</span>
                                                <span class="text-sm font-medium text-red-600 dark:text-red-300">-₹<?php echo e(number_format($payroll->professional_tax, 2)); ?></span>
                                            </div>
                                            <div class="border-t border-red-200 dark:border-red-700 my-2 pt-2">
                                                <div class="flex justify-between font-bold">
                                                    <span class="text-sm text-gray-900 dark:text-white">Total Deductions:</span>
                                                    <span class="text-sm text-red-600 dark:text-red-400">-₹<?php echo e(number_format(($payroll->employee_pf + $payroll->employee_esi + $payroll->professional_tax), 2)); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Net Salary -->
                            <div>
                                <div class="bg-green-900 bg-opacity-20 p-4 rounded-md border border-green-700">
                                    <div class="flex justify-between items-center">
                                        <span class="text-lg font-medium text-white">Net Salary (Monthly):</span>
                                        <span class="text-2xl font-bold text-green-400">₹<?php echo e(number_format($payroll->net_salary, 2)); ?></span>
                                    </div>
                                    <p class="text-xs text-gray-400 mt-1 text-right">* This amount is used for daily rate calculation</p>
                                </div>
                            </div>
                            <?php endif; ?>


                        </div>
                    </div>
                </div>
            </div>

            <!-- Status & Actions -->
            <div class="space-y-6">
                <!-- Status Card -->
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-4">Status</h3>
                        
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Current Status</label>
                                <span class="mt-1 inline-flex px-3 py-1 text-sm font-semibold rounded-full
                                    <?php if($payroll->status === 'paid'): ?> bg-red-900 text-red-200
                                    <?php elseif($payroll->status === 'approved'): ?> bg-yellow-900 text-yellow-200
                                    <?php else: ?> bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200 <?php endif; ?>">
                                    <?php echo e(ucfirst($payroll->status)); ?>

                                </span>
                            </div>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $payroll)): ?>
                                <?php if($payroll->status === 'pending'): ?>
                                    <form action="<?php echo e(route('payrolls.approve', $payroll)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                                            <i class="fas fa-check mr-2"></i>
                                            Approve Payroll
                                        </button>
                                    </form>
                                <?php endif; ?>
                                
                                <?php if($payroll->status === 'approved'): ?>
                                    <form action="<?php echo e(route('payrolls.markPaid', $payroll)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                            <i class="fas fa-money-bill-wave mr-2"></i>
                                            Mark as Paid
                                        </button>
                                    </form>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Quick Actions</h3>
                        
                        <div class="space-y-3">
                            <a href="<?php echo e(route('staff.show', $payroll->user)); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-user mr-2"></i>
                                View Employee
                            </a>
                            <a href="<?php echo e(route('attendance.index', ['user_id' => $payroll->user->id, 'month' => $payroll->month, 'year' => $payroll->year])); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-calendar-check mr-2"></i>
                                View Attendance
                            </a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Payroll::class)): ?>
                                <a href="<?php echo e(route('payrolls.create', ['user_id' => $payroll->user->id])); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                    <i class="fas fa-plus mr-2"></i>
                                    Create New Payroll
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Timestamps -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Record Information</h3>
                        
                        <div class="space-y-3">
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Created At</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->created_at->format('M j, Y g:i A')); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Last Updated</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->updated_at->format('M j, Y g:i A')); ?></p>
                            </div>
                            <?php if($payroll->status === 'paid' && $payroll->paid_at): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Paid At</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->paid_at->format('M j, Y g:i A')); ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yavis/hr/resources/views/payroll/show.blade.php ENDPATH**/ ?>