<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-100 dark:bg-gray-900 py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg border border-gray-200 dark:border-gray-600 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">
                            <i class="fas fa-chart-line mr-3 text-blue-500 dark:text-blue-400"></i>
                            Performance Analytics
                        </h1>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300">Comprehensive analysis of task completion rates, deadlines, and employee performance</p>
                    </div>
                    <div class="flex space-x-3">
                        <a href="<?php echo e(route('performance.export', request()->query())); ?>" 
                           class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            <i class="fas fa-download mr-2"></i>
                            Export CSV
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Date Range Filter -->
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg border border-gray-200 dark:border-gray-600 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <form method="GET" action="<?php echo e(route('performance.index')); ?>" class="flex flex-wrap items-end gap-4">
                    <div>
                        <label for="start_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                            <i class="fas fa-calendar mr-1"></i>
                            Start Date
                        </label>
                        <input type="date" id="start_date" name="start_date" 
                               value="<?php echo e(request('start_date', $dateRange['start']->format('Y-m-d'))); ?>"
                               class="px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>
                    <div>
                        <label for="end_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                            <i class="fas fa-calendar mr-1"></i>
                            End Date
                        </label>
                        <input type="date" id="end_date" name="end_date" 
                               value="<?php echo e(request('end_date', $dateRange['end']->format('Y-m-d'))); ?>"
                               class="px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                        <i class="fas fa-search mr-2"></i>
                        Update Report
                    </button>
                    <div class="text-sm text-gray-500 dark:text-gray-400 ml-auto">
                        <i class="fas fa-info-circle mr-1"></i>
                        Showing data from <?php echo e($dateRange['start']->format('M j, Y')); ?> to <?php echo e($dateRange['end']->format('M j, Y')); ?>

                    </div>
                </form>
            </div>
        </div>

        <!-- Overview Stats -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 shadow-sm">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-blue-100 dark:bg-blue-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-tasks text-blue-600 dark:text-white text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500 dark:text-gray-300">Total Tasks</p>
                        <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e(number_format($overview['total_tasks'])); ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 shadow-sm">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-green-100 dark:bg-green-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-check-circle text-green-600 dark:text-white text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500 dark:text-gray-300">Completion Rate</p>
                        <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e($overview['completion_rate']); ?>%</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo e(number_format($overview['completed_tasks'])); ?> completed</p>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 shadow-sm">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-yellow-100 dark:bg-yellow-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-clock text-yellow-600 dark:text-white text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500 dark:text-gray-300">On-Time Rate</p>
                        <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e($overview['on_time_rate']); ?>%</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo e(number_format($overview['on_time_tasks'])); ?> on time</p>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 shadow-sm">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-red-100 dark:bg-red-500 rounded-lg flex items-center justify-center">
                            <i class="fas fa-exclamation-triangle text-red-600 dark:text-white text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500 dark:text-gray-300">Overdue Tasks</p>
                        <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e(number_format($overview['overdue_tasks'])); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
            <!-- Task Completion Trend -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 shadow-sm">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                    <i class="fas fa-chart-line mr-2 text-blue-500 dark:text-blue-400"></i>
                    Task Completion Trend
                </h3>
                <canvas id="completionTrendChart" width="400" height="200"></canvas>
            </div>

            <!-- Completion by Priority -->
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 shadow-sm">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                    <i class="fas fa-chart-pie mr-2 text-green-500 dark:text-green-400"></i>
                    Completion by Priority
                </h3>
                <canvas id="priorityChart" width="400" height="200"></canvas>
            </div>
        </div>

        <!-- Status Distribution -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 mb-6 shadow-sm">
            <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                <i class="fas fa-chart-bar mr-2 text-purple-500 dark:text-purple-400"></i>
                Task Status Distribution
            </h3>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <?php $__currentLoopData = $taskCompletion['status_distribution']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="text-center">
                        <div class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e($status->count); ?></div>
                        <div class="text-sm text-gray-500 dark:text-gray-300 capitalize"><?php echo e(str_replace('_', ' ', $status->status)); ?></div>
                        <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2 mt-2">
                            <?php
                                $percentage = $overview['total_tasks'] > 0 ? ($status->count / $overview['total_tasks']) * 100 : 0;
                                $colorClass = match($status->status) {
                                    'completed' => 'bg-green-500',
                                    'in_progress' => 'bg-blue-500',
                                    'pending' => 'bg-yellow-500',
                                    default => 'bg-gray-500'
                                };
                            ?>
                            <div class="<?php echo e($colorClass); ?> h-2 rounded-full" style="width: <?php echo e($percentage); ?>%"></div>
                        </div>
                        <div class="text-xs text-gray-500 dark:text-gray-400 mt-1"><?php echo e(round($percentage, 1)); ?>%</div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Employee Performance -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 mb-6 shadow-sm">
            <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                <i class="fas fa-users mr-2 text-indigo-500 dark:text-indigo-400"></i>
                Top Employee Performance
            </h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead>
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Employee</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Department</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Tasks</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Completion Rate</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">On-Time Rate</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Attendance</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                        <?php $__currentLoopData = $employeePerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $performance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="w-8 h-8 bg-gray-200 dark:bg-gray-600 rounded-full flex items-center justify-center">
                                            <span class="text-sm font-medium text-gray-600 dark:text-white">
                                                <?php echo e(substr($performance['user']->name, 0, 1)); ?>

                                            </span>
                                        </div>
                                        <div class="ml-3">
                                            <div class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($performance['user']->name); ?></div>
                                            <div class="text-sm text-gray-500 dark:text-gray-400"><?php echo e($performance['user']->email); ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                    <?php echo e($performance['department']); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                    <div><?php echo e($performance['completed_tasks']); ?>/<?php echo e($performance['total_tasks']); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="w-16 bg-gray-200 dark:bg-gray-700 rounded-full h-2 mr-2">
                                            <div class="bg-green-500 h-2 rounded-full" style="width: <?php echo e($performance['completion_rate']); ?>%"></div>
                                        </div>
                                        <span class="text-sm text-gray-900 dark:text-white"><?php echo e($performance['completion_rate']); ?>%</span>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="w-16 bg-gray-200 dark:bg-gray-700 rounded-full h-2 mr-2">
                                            <div class="bg-blue-500 h-2 rounded-full" style="width: <?php echo e($performance['on_time_rate']); ?>%"></div>
                                        </div>
                                        <span class="text-sm text-gray-900 dark:text-white"><?php echo e($performance['on_time_rate']); ?>%</span>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="w-16 bg-gray-200 dark:bg-gray-700 rounded-full h-2 mr-2">
                                            <div class="bg-yellow-500 h-2 rounded-full" style="width: <?php echo e($performance['attendance_rate']); ?>%"></div>
                                        </div>
                                        <span class="text-sm text-gray-900 dark:text-white"><?php echo e($performance['attendance_rate']); ?>%</span>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Department Performance -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 p-6 shadow-sm">
            <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                <i class="fas fa-building mr-2 text-teal-500 dark:text-teal-400"></i>
                Department Performance
            </h3>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $departmentPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                        <div class="flex items-center justify-between mb-3">
                            <h4 class="text-lg font-medium text-gray-900 dark:text-white"><?php echo e($dept['department']->name); ?></h4>
                            <span class="text-sm text-gray-500 dark:text-gray-400"><?php echo e($dept['staff_count']); ?> staff</span>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-500 dark:text-gray-300">Tasks Completed</span>
                                <span class="text-gray-900 dark:text-white"><?php echo e($dept['completed_tasks']); ?>/<?php echo e($dept['total_tasks']); ?></span>
                            </div>
                            <div class="w-full bg-gray-200 dark:bg-gray-600 rounded-full h-2">
                                <div class="bg-green-500 h-2 rounded-full" style="width: <?php echo e($dept['completion_rate']); ?>%"></div>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-500 dark:text-gray-300">Completion Rate</span>
                                <span class="text-gray-900 dark:text-white font-medium"><?php echo e($dept['completion_rate']); ?>%</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-500 dark:text-gray-300">On-Time Rate</span>
                                <span class="text-gray-900 dark:text-white font-medium"><?php echo e($dept['on_time_rate']); ?>%</span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    function getChartColors() {
        const isDark = document.documentElement.classList.contains('dark');
        return {
            textColor: isDark ? 'rgb(209, 213, 219)' : 'rgb(55, 65, 81)', // gray-300 : gray-700
            gridColor: isDark ? 'rgba(75, 85, 99, 0.3)' : 'rgba(209, 213, 219, 0.5)', // gray-600 : gray-300
            borderColor: isDark ? 'rgb(31, 41, 55)' : 'rgb(255, 255, 255)' // gray-900 : white
        };
    }

    // Task Completion Trend Chart
    const trendCtx = document.getElementById('completionTrendChart').getContext('2d');
    const trendData = <?php echo json_encode($trends, 15, 512) ?>;

    let completionTrendChart = new Chart(trendCtx, {
        type: 'line',
        data: {
            labels: trendData.map(d => d.display_date),
            datasets: [{
                label: 'Tasks Created',
                data: trendData.map(d => d.total_tasks),
                borderColor: 'rgb(59, 130, 246)',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                tension: 0.4
            }, {
                label: 'Tasks Completed',
                data: trendData.map(d => d.completed_tasks),
                borderColor: 'rgb(34, 197, 94)',
                backgroundColor: 'rgba(34, 197, 94, 0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    labels: {
                        color: getChartColors().textColor
                    }
                }
            },
            scales: {
                x: {
                    ticks: {
                        color: getChartColors().textColor
                    },
                    grid: {
                        color: getChartColors().gridColor
                    }
                },
                y: {
                    ticks: {
                        color: getChartColors().textColor
                    },
                    grid: {
                        color: getChartColors().gridColor
                    }
                }
            }
        }
    });

    // Priority Completion Chart
    const priorityCtx = document.getElementById('priorityChart').getContext('2d');
    const priorityData = <?php echo json_encode($taskCompletion['by_priority'], 15, 512) ?>;

    let priorityChart = new Chart(priorityCtx, {
        type: 'doughnut',
        data: {
            labels: priorityData.map(p => p.priority.charAt(0).toUpperCase() + p.priority.slice(1)),
            datasets: [{
                data: priorityData.map(p => p.completion_rate),
                backgroundColor: [
                    'rgb(239, 68, 68)',   // red for urgent
                    'rgb(245, 158, 11)',  // yellow for high
                    'rgb(59, 130, 246)',  // blue for medium
                    'rgb(34, 197, 94)'    // green for low
                ],
                borderWidth: 2,
                borderColor: getChartColors().borderColor
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        color: getChartColors().textColor,
                        padding: 20
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const priority = priorityData[context.dataIndex];
                            return `${context.label}: ${context.parsed}% (${priority.completed}/${priority.total})`;
                        }
                    }
                }
            }
        }
    });

    // Listen for theme changes
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === "attributes" && mutation.attributeName === "class") {
                updateCharts();
            }
        });
    });

    observer.observe(document.documentElement, {
        attributes: true
    });

    function updateCharts() {
        const colors = getChartColors();
        
        // Update Trend Chart
        completionTrendChart.options.plugins.legend.labels.color = colors.textColor;
        completionTrendChart.options.scales.x.ticks.color = colors.textColor;
        completionTrendChart.options.scales.x.grid.color = colors.gridColor;
        completionTrendChart.options.scales.y.ticks.color = colors.textColor;
        completionTrendChart.options.scales.y.grid.color = colors.gridColor;
        completionTrendChart.update();

        // Update Priority Chart
        priorityChart.options.plugins.legend.labels.color = colors.textColor;
        priorityChart.data.datasets[0].borderColor = colors.borderColor;
        priorityChart.update();
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\StaffApp\HRApp\resources\views/performance/index.blade.php ENDPATH**/ ?>