<?php $__env->startSection('title', 'Apply for Leave'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="md:grid md:grid-cols-3 md:gap-6">
        <div class="md:col-span-1">
            <div class="px-4 sm:px-0">
                <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-white">Leave Application</h3>
                <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                    Submit your leave request for approval.
                </p>
                <div class="mt-4 bg-red-50 dark:bg-red-900/20 p-4 rounded-md">
                    <h4 class="text-sm font-medium text-red-800 dark:text-red-300">Current Balance</h4>
                    <p class="text-sm text-red-600 dark:text-red-400">
                        Used Paid Leaves: <?php echo e(Auth::user()->staffProfile->used_paid_leaves ?? 0); ?> / <?php echo e(Auth::user()->staffProfile->total_paid_leaves ?? 0); ?>

                    </p>
                </div>
            </div>
        </div>
        <div class="mt-5 md:mt-0 md:col-span-2">
            <form action="<?php echo e(route('leaves.requests.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="shadow sm:rounded-md sm:overflow-hidden">
    <div class="px-4 py-5 bg-white dark:bg-gray-800/50 backdrop-blur-md space-y-6 sm:p-6">
        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6 sm:col-span-3">
                                <label for="start_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Start Date</label>
                                <input type="date" name="start_date" id="start_date" required class="mt-1 focus:ring-red-500 focus:border-red-500 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-900 text-gray-900 dark:text-white">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="end_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">End Date</label>
                                <input type="date" name="end_date" id="end_date" required class="mt-1 focus:ring-red-500 focus:border-red-500 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-900 text-gray-900 dark:text-white">
                            </div>

                            <div class="col-span-6">
                                <div class="flex items-start">
                                    <div class="flex items-center h-5">
                                        <input id="is_half_day" name="is_half_day" type="checkbox" value="1" class="focus:ring-red-500 h-4 w-4 text-red-600 border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-900">
                                    </div>
                                    <div class="ml-3 text-sm">
                                        <label for="is_half_day" class="font-medium text-gray-700 dark:text-gray-300">Half Day Request</label>
                                        <p class="text-gray-500 dark:text-gray-400">Check this if you are applying for a half day (0.5 day).</p>
                                    </div>
                                </div>
                            </div>

                            <div class="col-span-6">
                                <label for="reason" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Reason</label>
                                <div class="mt-1">
                                    <textarea id="reason" name="reason" rows="3" required class="shadow-sm focus:ring-red-500 focus:border-red-500 mt-1 block w-full sm:text-sm border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-900 text-gray-900 dark:text-white"></textarea>
                                </div>
                                <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">Brief description of why you are taking leave.</p>
                            </div>
                        </div>
                    </div>
                    <div class="px-4 py-3 bg-gray-50 dark:bg-gray-800/50 backdrop-blur-md text-right sm:px-6">
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            Submit Request
                        </button>
                    </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yavis/hr/resources/views/leaves/requests/create.blade.php ENDPATH**/ ?>