<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-white">Task Details</h1>
                        <p class="mt-1 text-sm text-gray-300">View task information and progress</p>
                    </div>
                    <div class="flex space-x-3">
                            <a href="<?php echo e(route('tasks.index')); ?>" class="inline-flex items-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                <i class="fas fa-arrow-left mr-2"></i>
                                Back to List
                            </a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAssignmentHistory', $task)): ?>
                                <a href="<?php echo e(route('tasks.assignment-history', $task)); ?>" class="inline-flex items-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                    <i class="fas fa-history mr-2"></i>
                                    Assignment History
                                </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $task)): ?>
                                <a href="<?php echo e(route('tasks.edit', $task)); ?>" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    <i class="fas fa-edit mr-2"></i>
                                    Edit
                                </a>
                            <?php endif; ?>
                        </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Task Information -->
            <div class="lg:col-span-2">
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <div class="flex items-start justify-between mb-6">
                            <div>
                                <h3 class="text-xl font-semibold text-white"><?php echo e($task->title); ?></h3>
                                <div class="mt-2 flex items-center space-x-4">
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                        <?php if($task->status === 'completed'): ?> bg-green-100 text-green-800
                                        <?php elseif($task->status === 'in_progress'): ?> bg-blue-100 text-blue-800
                                        <?php elseif($task->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                                        <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $task->status))); ?>

                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Task Description -->
                        <?php if($task->description): ?>
                        <div class="mb-6">
                            <h4 class="text-md font-medium text-white mb-3">Description</h4>
                            <div class="bg-gray-700 p-4 rounded-md border border-gray-600">
                                <p class="text-sm text-gray-300 whitespace-pre-wrap"><?php echo e($task->description); ?></p>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Task Details -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Created By</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($task->creator->name); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Assigned To</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($task->currentAssignee->name ?? 'Unassigned'); ?></p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-300">Department</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($task->currentDepartment->name ?? 'No Department'); ?></p>
                            </div>

                        </div>

                        <!-- Timestamps -->
                        <div class="mt-8 pt-6 border-t border-gray-700">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Created At</label>
                                    <p class="mt-1 text-sm text-white"><?php echo e($task->created_at->format('M j, Y g:i A')); ?></p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Last Updated</label>
                                    <p class="mt-1 text-sm text-white"><?php echo e($task->updated_at->format('M j, Y g:i A')); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Task Timeline -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mt-6">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Task Timeline</h3>
                        
                        <div class="flow-root">
                            <ul class="-mb-8">
                                <!-- Task Creation -->
                                <li>
                                    <div class="relative pb-8">
                                        <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-600" aria-hidden="true"></span>
                                        <div class="relative flex space-x-3">
                                            <div>
                                                <span class="h-8 w-8 rounded-full bg-blue-500 flex items-center justify-center ring-8 ring-gray-800">
                                                    <i class="fas fa-plus text-white text-xs"></i>
                                                </span>
                                            </div>
                                            <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                                <div>
                                                    <p class="text-sm text-white">Task created by <span class="font-medium"><?php echo e($task->creator->name); ?></span></p>
                                                    <p class="text-xs text-gray-400"><?php echo e($task->created_at->format('M j, Y g:i A')); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                
                                <!-- Assignment History -->
                                <?php $__empty_1 = true; $__currentLoopData = $task->assignments->sortBy('assigned_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <li>
                                        <div class="relative pb-8">
                                            <?php if(!$loop->last): ?>
                                                <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-600" aria-hidden="true"></span>
                                            <?php endif; ?>
                                            <div class="relative flex space-x-3">
                                                <div>
                                                    <?php if($assignment->status === 'completed'): ?>
                                                        <span class="h-8 w-8 rounded-full bg-green-500 flex items-center justify-center ring-8 ring-gray-800">
                                                            <i class="fas fa-check text-white text-xs"></i>
                                                        </span>
                                                    <?php elseif($assignment->status === 'reassigned'): ?>
                                                        <span class="h-8 w-8 rounded-full bg-yellow-500 flex items-center justify-center ring-8 ring-gray-800">
                                                            <i class="fas fa-exchange-alt text-white text-xs"></i>
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="h-8 w-8 rounded-full bg-blue-500 flex items-center justify-center ring-8 ring-gray-800">
                                                            <i class="fas fa-user text-white text-xs"></i>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                                    <div>
                                                        <?php if($assignment->status === 'completed'): ?>
                                                            <p class="text-sm text-white">Task completed by <span class="font-medium"><?php echo e($assignment->assignedTo->name); ?></span></p>
                                                            <?php if($assignment->completed_at): ?>
                                                                <p class="text-xs text-gray-400"><?php echo e($assignment->completed_at->format('M j, Y g:i A')); ?></p>
                                                            <?php endif; ?>
                                                        <?php elseif($assignment->status === 'reassigned'): ?>
                                                            <p class="text-sm text-white">Task reassigned from <span class="font-medium"><?php echo e($assignment->assignedTo->name); ?></span> by <span class="font-medium"><?php echo e($assignment->assignedBy->name); ?></span></p>
                                                            <p class="text-xs text-gray-400"><?php echo e($assignment->assigned_at->format('M j, Y g:i A')); ?></p>
                                                        <?php else: ?>
                                                            <p class="text-sm text-white">Task assigned to <span class="font-medium"><?php echo e($assignment->assignedTo->name); ?></span> by <span class="font-medium"><?php echo e($assignment->assignedBy->name); ?></span></p>
                                                            <p class="text-xs text-gray-400"><?php echo e($assignment->assigned_at->format('M j, Y g:i A')); ?></p>
                                                        <?php endif; ?>
                                                        
                                                        <?php if($assignment->department): ?>
                                                            <p class="text-xs text-gray-500">Department: <?php echo e($assignment->department->name); ?></p>
                                                        <?php endif; ?>
                                                        
                                                        <?php if($assignment->notes): ?>
                                                            <p class="text-xs text-gray-400 mt-1 italic">"<?php echo e($assignment->notes); ?>"</p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <li>
                                        <div class="relative pb-8">
                                            <div class="relative flex space-x-3">
                                                <div>
                                                    <span class="h-8 w-8 rounded-full bg-gray-500 flex items-center justify-center ring-8 ring-gray-800">
                                                        <i class="fas fa-clock text-white text-xs"></i>
                                                    </span>
                                                </div>
                                                <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                                    <div>
                                                        <p class="text-sm text-gray-400">No assignments yet</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Task Actions & Info -->
            <div class="space-y-6">
                <!-- Task Actions -->
                <?php if($task->status !== 'completed'): ?>
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Quick Actions</h3>
                        
                        <div class="space-y-3">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('complete', $task)): ?>
                                <?php if($task->status !== 'completed'): ?>
                                    <form action="<?php echo e(route('tasks.complete', $task)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to mark this task as completed? This action cannot be undone.')">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                            <i class="fas fa-check mr-2"></i>
                                            Mark Complete (Super Admin Only)
                                        </button>
                                    </form>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reassign', $task)): ?>
                            <?php if($task->status !== 'completed'): ?>
                                <a href="<?php echo e(route('tasks.reassign.form', $task)); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                    <i class="fas fa-user-edit mr-2"></i>
                                    Reassign Task
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Task Progress -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Task Progress</h3>
                        
                        <div class="space-y-4">
                            <div class="flex items-center justify-between">
                                <span class="text-sm text-gray-300">Status</span>
                                <span class="text-sm font-medium text-white"><?php echo e(ucfirst(str_replace('_', ' ', $task->status))); ?></span>
                            </div>


                            <div class="flex items-center justify-between">
                                <span class="text-sm text-gray-300">Days Since Created</span>
                                <span class="text-sm font-medium text-white"><?php echo e($task->created_at->diffInDays()); ?> days</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reassign Task Modal -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/tasks/show.blade.php ENDPATH**/ ?>