<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 py-6">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white">My Attendance</h1>
            <p class="text-gray-400 mt-1">View your attendance calendar for <?php echo e(now()->format('F Y')); ?></p>
        </div>

        <!-- Calendar -->
        <div class="bg-gray-800 rounded-lg shadow-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-700">
                <h2 class="text-xl font-semibold text-white">Attendance Calendar</h2>
            </div>
            
            <div class="p-6">
                <!-- Calendar Grid -->
                <div class="grid grid-cols-7 gap-1 mb-4">
                    <!-- Day Headers -->
                    <div class="text-center py-2 text-sm font-medium text-gray-300">Sun</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-300">Mon</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-300">Tue</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-300">Wed</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-300">Thu</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-300">Fri</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-300">Sat</div>
                </div>

                <div class="grid grid-cols-7 gap-1">
                    <?php
                        $startOfMonth = now()->startOfMonth();
                        $endOfMonth = now()->endOfMonth();
                        $startDate = $startOfMonth->copy()->startOfWeek();
                        $endDate = $endOfMonth->copy()->endOfWeek();
                        $currentDate = $startDate->copy();
                        
                        // Create attendance lookup array
                        $attendanceByDate = $attendances->keyBy(function($item) {
                            return $item->date->format('Y-m-d');
                        });
                    ?>

                    <?php while($currentDate <= $endDate): ?>
                        <?php
                            $dateKey = $currentDate->format('Y-m-d');
                            $attendance = $attendanceByDate->get($dateKey);
                            $isCurrentMonth = $currentDate->month === now()->month;
                            $isToday = $currentDate->isToday();
                        ?>
                        
                        <div class="relative h-16 border border-gray-700 rounded <?php echo e($isCurrentMonth ? 'bg-gray-700' : 'bg-gray-800'); ?> <?php echo e($isToday ? 'ring-2 ring-blue-500' : ''); ?>">
                            <!-- Date Number -->
                            <div class="absolute top-1 left-1 text-xs <?php echo e($isCurrentMonth ? 'text-white' : 'text-gray-500'); ?>">
                                <?php echo e($currentDate->day); ?>

                            </div>
                            
                            <?php if($isCurrentMonth && $attendance): ?>
                                <!-- Attendance Status -->
                                <div class="absolute bottom-1 left-1 right-1">
                                    <?php if($attendance->status === 'present'): ?>
                                        <div class="w-full h-2 bg-green-500 rounded-sm" title="Present"></div>
                                    <?php elseif($attendance->status === 'late'): ?>
                                        <div class="w-full h-2 bg-yellow-500 rounded-sm" title="Late"></div>
                                    <?php elseif($attendance->status === 'absent'): ?>
                                        <div class="w-full h-2 bg-red-500 rounded-sm" title="Absent"></div>
                                    <?php elseif($attendance->status === 'half_day'): ?>
                                        <div class="w-full h-2 bg-blue-500 rounded-sm" title="Half Day"></div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Status Icon -->
                                <div class="absolute top-1 right-1">
                                    <?php if($attendance->status === 'present'): ?>
                                        <i class="fas fa-check text-green-400 text-xs"></i>
                                    <?php elseif($attendance->status === 'late'): ?>
                                        <i class="fas fa-clock text-yellow-400 text-xs"></i>
                                    <?php elseif($attendance->status === 'absent'): ?>
                                        <i class="fas fa-times text-red-400 text-xs"></i>
                                    <?php elseif($attendance->status === 'half_day'): ?>
                                        <i class="fas fa-adjust text-blue-400 text-xs"></i>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <?php
                            $currentDate->addDay();
                        ?>
                    <?php endwhile; ?>
                </div>
                
                <!-- Legend -->
                <div class="mt-6 flex flex-wrap gap-4 justify-center">
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-green-500 rounded-sm"></div>
                        <span class="text-sm text-gray-300">Present</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-yellow-500 rounded-sm"></div>
                        <span class="text-sm text-gray-300">Late</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-red-500 rounded-sm"></div>
                        <span class="text-sm text-gray-300">Absent</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-blue-500 rounded-sm"></div>
                        <span class="text-sm text-gray-300">Half Day</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/attendance/staff.blade.php ENDPATH**/ ?>