<?php $__env->startSection('content'); ?>
<div class="flex-1 p-6">
    <div class="max-w-7xl mx-auto">
        <!-- Header Section -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e(__('Payroll Management')); ?></h1>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300">Manage employee payroll records and generate monthly payrolls</p>
                    </div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Payroll::class)): ?>
                        <div class="mt-4 sm:mt-0">
                            <button type="button" class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors duration-200" onclick="openCreatePayrollModal()">
                                <i class="fas fa-plus mr-2"></i> Create Payroll
                            </button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
            <div class="p-6">
                <?php if(session('success')): ?>
                    <div class="mb-6 bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-800 rounded-lg p-4">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <i class="fas fa-check-circle text-green-400 dark:text-green-500"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-green-800 dark:text-green-200"><?php echo e(session('success')); ?></p>
                            </div>
                            <div class="ml-auto pl-3">
                                <button type="button" class="inline-flex text-green-500 dark:text-green-400 hover:text-green-600 dark:hover:text-green-300" onclick="this.parentElement.parentElement.parentElement.remove()">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Filter Form -->
                <?php if(auth()->user()->hasRole('Admin')): ?>
                    <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4 mb-6">
                        <form method="GET" action="<?php echo e(route('payrolls.index')); ?>" class="space-y-4">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                                <div>
                                    <label for="user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Staff Member</label>
                                    <select name="user_id" id="user_id" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                        <option value="">All Staff</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>>
                                                <?php echo e($user->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div>
                                    <label for="month" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Month</label>
                                    <select name="month" id="month" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                        <option value="">All Months</option>
                                        <?php for($i = 1; $i <= 12; $i++): ?>
                                            <option value="<?php echo e($i); ?>" <?php echo e(request('month') == $i ? 'selected' : ''); ?>>
                                                <?php echo e(date('F', mktime(0, 0, 0, $i, 1))); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <div>
                                    <label for="year" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Year</label>
                                    <select name="year" id="year" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                        <option value="">All Years</option>
                                        <?php for($i = 2020; $i <= 2030; $i++): ?>
                                            <option value="<?php echo e($i); ?>" <?php echo e(request('year') == $i ? 'selected' : ''); ?>>
                                                <?php echo e($i); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <div class="flex items-end">
                                    <div class="flex gap-2">
                                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                                            <i class="fas fa-filter mr-2"></i> Filter
                                        </button>
                                        <a href="<?php echo e(route('payrolls.index')); ?>" class="inline-flex items-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                                            <i class="fas fa-times mr-2"></i> Clear
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                <?php endif; ?>

                <?php if($payrolls->count() > 0): ?>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Type</th>
                                    <?php if(auth()->user()->hasRole('Admin')): ?>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Employee/Group</th>
                                    <?php endif; ?>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Period</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Amount</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                <?php $__currentLoopData = $payrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                        <!-- Type Column -->
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <?php if(isset($payroll->payroll_type) && $payroll->payroll_type === 'bulk'): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                                    <i class="fas fa-users mr-1"></i>
                                                    Bulk
                                                </span>
                                            <?php else: ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                    <i class="fas fa-user mr-1"></i>
                                                    Individual
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        
                                        <?php if(auth()->user()->hasRole('Admin')): ?>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <?php if(isset($payroll->payroll_type) && $payroll->payroll_type === 'bulk'): ?>
                                                    <div class="flex items-center">
                                                        <div class="flex-shrink-0 h-8 w-8">
                                                            <div class="h-8 w-8 rounded-full bg-purple-600 flex items-center justify-center">
                                                                <i class="fas fa-users text-sm text-white"></i>
                                                            </div>
                                                        </div>
                                                        <div class="ml-3">
                                                            <div class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($payroll->employee_count); ?> Employees</div>
                                                            <div class="text-xs text-gray-500 dark:text-gray-400">Batch: <?php echo e(date('M Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?></div>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="flex items-center">
                                                        <div class="flex-shrink-0 h-8 w-8">
                                                            <div class="h-8 w-8 rounded-full bg-gray-200 dark:bg-gray-600 flex items-center justify-center">
                                                                <span class="text-sm font-medium text-gray-600 dark:text-gray-200"><?php echo e(substr($payroll->user->name, 0, 1)); ?></span>
                                                            </div>
                                                        </div>
                                                        <div class="ml-3">
                                                            <div class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($payroll->user->name); ?></div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                        <?php endif; ?>
                                        
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-white"><?php echo e(date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?></td>
                                        
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900 dark:text-white">
                                            <?php if(isset($payroll->payroll_type) && $payroll->payroll_type === 'bulk'): ?>
                                                ₹<?php echo e(number_format($payroll->total_amount, 2)); ?>

                                            <?php else: ?>
                                                ₹<?php echo e(number_format($payroll->total_payout, 2)); ?>

                                            <?php endif; ?>
                                        </td>
                                        
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <div class="flex items-center space-x-2">
                                                <?php if(isset($payroll->payroll_type) && $payroll->payroll_type === 'bulk'): ?>
                                                    <a href="<?php echo e(route('payrolls.bulk.show', $payroll->batch_id)); ?>" class="inline-flex items-center p-2 text-red-600 hover:text-red-900 hover:bg-red-50 rounded-lg transition-colors duration-200" title="View Bulk Details">
                                                        <i class="fas fa-eye text-sm"></i>
                                                    </a>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $payroll)): ?>
                                                        <form action="<?php echo e(route('payrolls.bulk.destroy', $payroll->batch_id)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this entire bulk payroll batch? This will remove all <?php echo e($payroll->employee_count); ?> payroll records for <?php echo e($payroll->month); ?>/<?php echo e($payroll->year); ?>.')">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="inline-flex items-center p-2 text-red-600 hover:text-red-900 hover:bg-red-50 rounded-lg transition-colors duration-200" title="Delete Bulk Payroll">
                                                                <i class="fas fa-trash text-sm"></i>
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="<?php echo e(route('payrolls.show', $payroll)); ?>" class="inline-flex items-center p-2 text-red-600 hover:text-red-900 hover:bg-red-50 rounded-lg transition-colors duration-200" title="View Details">
                                                        <i class="fas fa-eye text-sm"></i>
                                                    </a>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $payroll)): ?>
                                                        <a href="<?php echo e(route('payrolls.edit', $payroll)); ?>" class="inline-flex items-center p-2 text-yellow-600 hover:text-yellow-900 hover:bg-yellow-50 rounded-lg transition-colors duration-200" title="Edit">
                                                            <i class="fas fa-edit text-sm"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $payroll)): ?>
                                                        <form action="<?php echo e(route('payrolls.destroy', $payroll)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this payroll record?')">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="inline-flex items-center p-2 text-red-600 hover:text-red-900 hover:bg-red-50 rounded-lg transition-colors duration-200" title="Delete">
                                                                <i class="fas fa-trash text-sm"></i>
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-6 flex justify-center">
                        <?php echo e($payrolls->appends(request()->query())->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-12">
                        <div class="mx-auto h-24 w-24 text-gray-400 dark:text-gray-500 mb-4">
                            <i class="fas fa-money-bill-wave text-6xl"></i>
                        </div>
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-2">No payroll records found</h3>
                        <p class="text-gray-500 dark:text-gray-400 mb-6">Get started by creating your first payroll record.</p>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Create Payroll Modal -->
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Payroll::class)): ?>
<div id="createPayrollModal" class="fixed inset-0 bg-gray-900 bg-opacity-75 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-10 mx-auto p-5 border border-gray-200 dark:border-gray-600 w-full max-w-md shadow-lg rounded-md bg-white dark:bg-gray-800">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">Create Payroll</h3>
                <button type="button" class="text-gray-400 hover:text-gray-500 dark:hover:text-gray-300" onclick="closeCreatePayrollModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form id="createPayrollForm" method="POST" action="<?php echo e(route('payrolls.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <!-- Payroll Type Selection -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payroll Type</label>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="radio" name="payroll_type" value="individual" class="text-red-600 focus:ring-red-500 border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" checked onchange="toggleUserSelection()">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Individual User</span>
                            </label>
                            <label class="flex items-center">
                                <input type="radio" name="payroll_type" value="bulk" class="text-red-600 focus:ring-red-500 border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700" onchange="toggleUserSelection()">
                                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">All Users</span>
                            </label>
                        </div>
                    </div>

                    <!-- User Selection (for individual) -->
                    <div id="userSelection">
                        <label for="user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Select User</label>
                        <select name="user_id" id="user_id" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500">
                            <option value="">Choose a user...</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>">
                                    <?php echo e($user->name); ?> (<?php echo e($user->staffProfile->employee_id ?? 'N/A'); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Date Selection -->
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="month" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Month</label>
                            <select name="month" id="month" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500" required>
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <option value="<?php echo e($i); ?>" <?php echo e(date('n') == $i ? 'selected' : ''); ?>>
                                        <?php echo e(date('F', mktime(0, 0, 0, $i, 1))); ?>

                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div>
                            <label for="year" class="block text-sm font-medium text-gray-300 mb-1">Year</label>
                            <select name="year" id="year" class="w-full px-3 py-2 border border-gray-600 bg-gray-700 text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500" required>
                                <?php for($i = 2020; $i <= 2030; $i++): ?>
                                    <option value="<?php echo e($i); ?>" <?php echo e(date('Y') == $i ? 'selected' : ''); ?>>
                                        <?php echo e($i); ?>

                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Info Box -->
                    <div class="bg-red-900 border border-red-700 rounded-lg p-4">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="fas fa-info-circle text-red-300"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-red-200" id="infoText">
                                    Payroll will be calculated based on attendance records. Working days exclude Sundays. Existing records will be skipped.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" class="px-4 py-2 bg-gray-300 hover:bg-gray-400 text-gray-800 text-sm font-medium rounded-lg transition-colors duration-200" onclick="closeCreatePayrollModal()">Cancel</button>
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-plus mr-2"></i> Create Payroll
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openCreatePayrollModal() {
    document.getElementById('createPayrollModal').classList.remove('hidden');
}

function closeCreatePayrollModal() {
    document.getElementById('createPayrollModal').classList.add('hidden');
    // Reset form
    document.getElementById('createPayrollForm').reset();
    document.querySelector('input[name="payroll_type"][value="individual"]').checked = true;
    toggleUserSelection();
}

// Form validation
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('createPayrollForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            console.log('Form submission started');
            const payrollType = document.querySelector('input[name="payroll_type"]:checked')?.value;
            const userSelect = document.getElementById('user_id');
            const userId = userSelect?.value;
            const month = document.getElementById('month')?.value;
            const year = document.getElementById('year')?.value;
            
            console.log('Form data:', {
                payroll_type: payrollType,
                user_id: userId,
                user_select_element: userSelect,
                month: month,
                year: year
            });
            
            
            
            console.log('Form validation passed, submitting...');
        });
    }
});

function toggleUserSelection() {
    const payrollType = document.querySelector('input[name="payroll_type"]:checked')?.value;
    const userSelection = document.getElementById('userSelection');
    const userSelect = document.getElementById('user_id');
    const infoText = document.getElementById('infoText');
    const form = document.getElementById('createPayrollForm');
    
    // Check if elements exist before manipulating them
    if (!payrollType || !userSelection || !userSelect || !infoText || !form) {
        console.error('Required elements not found for toggleUserSelection');
        return;
    }
    
    // Always use the same route - the controller will handle both cases
    form.action = '<?php echo e(route("payrolls.store")); ?>';
    
    if (payrollType === 'individual') {
        userSelection.style.display = 'block';
        userSelect.required = true;
        infoText.textContent = 'Payroll will be calculated for the selected user based on their attendance records. Working days exclude Sundays.';
    } else if (payrollType === 'bulk') {
        userSelection.style.display = 'none';
        userSelect.required = false;
        userSelect.value = '';
        infoText.textContent = 'Payroll will be generated for all staff members based on their attendance records. Working days exclude Sundays. Existing records will be skipped.';
    }
}

// Close modal when clicking outside
document.getElementById('createPayrollModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeCreatePayrollModal();
    }
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleUserSelection();
    

});
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\StaffApp\HRApp\resources\views/payroll/index.blade.php ENDPATH**/ ?>