<?php $__env->startSection('title', 'Leave Requests'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow overflow-hidden sm:rounded-lg border border-gray-200 dark:border-gray-700">
    <div class="px-4 py-5 sm:px-6 flex justify-between items-center border-b border-gray-200 dark:border-gray-700">
        <div>
            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">
                Leave Requests
            </h3>
            <p class="mt-1 max-w-2xl text-sm text-gray-500 dark:text-gray-400">
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?> Manage employee leave applications. <?php else: ?> Track your leave applications. <?php endif; ?>
            </p>
        </div>
        <div class="flex space-x-3">
            <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
            <a href="<?php echo e(route('leaves.types.index')); ?>" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                Manage Leave Types
            </a>
            <?php endif; ?>
            <a href="<?php echo e(route('leaves.requests.create')); ?>" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                Apply for Leave
            </a>
        </div>
    </div>
    <div class="border-t border-gray-200 dark:border-gray-700">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-700/50">
                <tr>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                        Employee
                    </th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                        Date Range
                    </th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                        Type / Reason
                    </th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                        Status
                    </th>
                    <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                    <th scope="col" class="relative px-6 py-3">
                        <span class="sr-only">Action</span>
                    </th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody class="bg-white dark:bg-transparent divide-y divide-gray-200 dark:divide-gray-700">
                <?php $__currentLoopData = $leaveRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors duration-150">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-10 w-10">
                                <span class="h-10 w-10 rounded-full bg-gray-200 dark:bg-gray-600 flex items-center justify-center font-bold text-gray-500 dark:text-gray-300">
                                    <?php echo e(substr($request->user->name, 0, 1)); ?>

                                </span>
                            </div>
                            <div class="ml-4">
                                <div class="text-sm font-medium text-gray-900 dark:text-white">
                                    <?php echo e($request->user->name); ?>

                                </div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">
                                    <?php echo e($request->user->email); ?>

                                </div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900 dark:text-white">
                            <?php echo e(\Carbon\Carbon::parse($request->start_date)->format('M d, Y')); ?> 
                            - 
                            <?php echo e(\Carbon\Carbon::parse($request->end_date)->format('M d, Y')); ?>

                        </div>
                        <div class="text-sm text-gray-500 dark:text-gray-400">
                            <?php if($request->is_half_day): ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300">Half Day</span>
                            <?php else: ?>
                                <?php echo e(\Carbon\Carbon::parse($request->start_date)->diffInDays(\Carbon\Carbon::parse($request->end_date)) + 1); ?> Days
                            <?php endif; ?>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <div class="text-sm text-gray-900 dark:text-white font-medium">
                            <?php echo e($request->leaveType->name ?? 'Pending Assignment'); ?>

                        </div>
                        <div class="text-sm text-gray-500 dark:text-gray-400 truncate max-w-xs" title="<?php echo e($request->reason); ?>">
                            <?php echo e($request->reason); ?>

                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <?php if($request->status == 'approved'): ?>
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300">
                                Approved
                            </span>
                        <?php elseif($request->status == 'rejected'): ?>
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300">
                                Rejected
                            </span>
                        <?php else: ?>
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300">
                                Pending
                            </span>
                        <?php endif; ?>
                    </td>
                    <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                        <?php if($request->status == 'pending'): ?>
                            <button onclick="openApprovalModal(<?php echo e($request->id); ?>)" class="text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300">Review</button>
                        <?php endif; ?>
                    </td>
                    <?php endif; ?>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <div class="px-4 py-3 border-t border-gray-200 dark:border-gray-700 sm:px-6">
            <?php echo e($leaveRequests->links()); ?>

        </div>
    </div>
</div>

<?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
<!-- Approval Modal -->
<div id="approvalModal" class="fixed z-10 inset-0 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true" onclick="closeApprovalModal()"></div>
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        <div class="inline-block align-bottom bg-white dark:bg-gray-800/50 backdrop-blur-md rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full border border-gray-200 dark:border-gray-700">
            <form id="approvalForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="bg-white dark:bg-transparent px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <div class="sm:flex sm:items-start">
                        <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white" id="modal-title">
                                Review Leave Request
                            </h3>
                            <div class="mt-4 space-y-4">
                        <div class="mt-4">
                            <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                            <select id="status" name="status" onchange="toggleLeaveType()" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-900 text-gray-900 dark:text-white focus:outline-none focus:ring-red-500 focus:border-transparent sm:text-sm rounded-md">
                                <option value="approved">Approve</option>
                                <option value="rejected">Reject</option>
                            </select>
                        </div>
                        <div class="mt-4" id="leave_type_container">
                            <label for="leave_type_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Leave Type</label>
                            <select id="leave_type_id" name="leave_type_id" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-900 text-gray-900 dark:text-white focus:outline-none focus:ring-red-500 focus:border-transparent sm:text-sm rounded-md">
                                <?php $__currentLoopData = \App\Models\LeaveType::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type->id); ?>"><?php echo e($type->name); ?> (<?php echo e($type->deduction_percentage); ?>% Deduction)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                                <div>
                                    <label for="admin_comment" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Comment (Optional)</label>
                                    <textarea id="admin_comment" name="admin_comment" rows="3" class="shadow-sm focus:ring-red-500 focus:border-red-500 mt-1 block w-full sm:text-sm border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-white rounded-md"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 dark:bg-gray-700/50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="submit" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:ml-3 sm:w-auto sm:text-sm">
                        Submit
                    </button>
                    <button type="button" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 dark:border-gray-600 shadow-sm px-4 py-2 bg-white dark:bg-gray-800 text-base font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm" onclick="closeApprovalModal()">
                        Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function openApprovalModal(id) {
        document.getElementById('approvalForm').action = "/leaves/requests/" + id;
        document.getElementById('approvalModal').classList.remove('hidden');
    }

    function closeApprovalModal() {
        document.getElementById('approvalModal').classList.add('hidden');
    }

    function toggleLeaveType() {
        const status = document.getElementById('status').value;
        const container = document.getElementById('leaveTypeContainer');
        if (status === 'rejected') {
            container.classList.add('hidden');
            document.getElementById('leave_type_id').removeAttribute('required');
        } else {
            container.classList.remove('hidden');
            document.getElementById('leave_type_id').setAttribute('required', 'required');
        }
    }
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yavis/hr/resources/views/leaves/requests/index.blade.php ENDPATH**/ ?>