<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Staff Management System</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

        <!-- Styles / Scripts -->
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
    </head>
    <body class="min-h-screen bg-gradient-to-br from-gray-900 via-blue-900 to-red-900">
        <div class="min-h-screen flex flex-col justify-center items-center px-4">
            <!-- Header -->
            <div class="text-center mb-12">
                <div class="mb-6">
                    <svg class="w-20 h-20 mx-auto text-red-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <h1 class="text-4xl md:text-6xl font-bold text-white mb-4">
                    Staff Management System
                </h1>
                <p class="text-xl text-gray-300 max-w-2xl mx-auto">
                    Streamline your workforce management with our comprehensive internal platform
                </p>
            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-12 max-w-4xl">
                <div class="text-center p-6 bg-gray-800/50 rounded-lg border border-gray-700">
                    <div class="mb-4">
                        <i class="fas fa-users text-3xl text-red-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">Staff Management</h3>
                    <p class="text-gray-400">Manage employee profiles, departments, and organizational structure</p>
                </div>
                
                <div class="text-center p-6 bg-gray-800/50 rounded-lg border border-gray-700">
                    <div class="mb-4">
                        <i class="fas fa-tasks text-3xl text-red-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">Task Tracking</h3>
                    <p class="text-gray-400">Assign, monitor, and track tasks across departments</p>
                </div>
                
                <div class="text-center p-6 bg-gray-800/50 rounded-lg border border-gray-700">
                    <div class="mb-4">
                        <i class="fas fa-calendar-check text-3xl text-red-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">Attendance</h3>
                    <p class="text-gray-400">Track attendance and manage payroll efficiently</p>
                </div>
            </div>

            <!-- Login Section -->
            @if (Route::has('login'))
                <div class="text-center">
                    @auth
                        <a href="{{ url('/dashboard') }}" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white font-semibold rounded-lg shadow-lg transition-all duration-200 transform hover:scale-105">
                            <i class="fas fa-tachometer-alt mr-2"></i>
                            Go to Dashboard
                        </a>
                    @else
                        <div class="space-y-4">
                            <p class="text-gray-300 mb-6">Access your account to get started</p>
                            <div class="space-x-4">
                                <a href="{{ route('login') }}" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white font-semibold rounded-lg shadow-lg transition-all duration-200 transform hover:scale-105">
                                    <i class="fas fa-sign-in-alt mr-2"></i>
                                    Login
                                </a>
                            </div>
                        </div>
                    @endauth
                </div>
            @endif

            <!-- Footer -->
            <div class="mt-16 text-center">
                <p class="text-gray-500 text-sm">
                    &copy; {{ date('Y') }} Staff Management System. Internal Use Only.
                </p>
            </div>
        </div>
    </body>
</html>
