@extends('layouts.app')

@section('page-title', 'Assignment History')

@section('content')
<div class="bg-white dark:bg-gray-800/50 backdrop-blur-md rounded-lg shadow-xl border border-gray-200 dark:border-gray-700">
    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-4 sm:mb-0">
                <i class="fas fa-history mr-3 text-purple-500 dark:text-purple-400"></i>
                Assignment History - {{ $task->title }}
            </h1>
            <a href="{{ route('tasks.show', $task) }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>Back to Task
            </a>
        </div>
    </div>

    <div class="p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-600 pb-2">
                    <i class="fas fa-info-circle mr-2 text-red-500 dark:text-red-400"></i>Task Details
                </h3>
                <div class="space-y-2">
                    <p class="text-sm text-gray-500 dark:text-gray-300"><span class="font-medium text-gray-900 dark:text-white">Title:</span> {{ $task->title }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-300"><span class="font-medium text-gray-900 dark:text-white">Created by:</span> {{ $task->creator->name }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-300">
                        <span class="font-medium text-gray-900 dark:text-white">Current Status:</span>
                        @if($task->status === 'completed')
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300">
                                <i class="fas fa-check mr-1"></i>{{ ucfirst($task->status) }}
                            </span>
                        @elseif($task->status === 'in_progress')
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300">
                                <i class="fas fa-clock mr-1"></i>{{ ucfirst(str_replace('_', ' ', $task->status)) }}
                            </span>
                        @elseif($task->status === 'cancelled')
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300">
                                <i class="fas fa-ban mr-1"></i>{{ ucfirst($task->status) }}
                            </span>
                        @else
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">
                                <i class="fas fa-pause mr-1"></i>{{ ucfirst($task->status) }}
                            </span>
                        @endif
                    </p>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                @if($task->currentAssignment)
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-600 pb-2">
                    <i class="fas fa-user-check mr-2 text-red-500 dark:text-red-400"></i>Current Assignment
                </h3>
                <div class="space-y-2">
                    <p class="text-sm text-gray-500 dark:text-gray-300"><span class="font-medium text-gray-900 dark:text-white">Assigned to:</span> {{ $task->currentAssignment->assignedTo->name }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-300"><span class="font-medium text-gray-900 dark:text-white">Assigned by:</span> {{ $task->currentAssignment->assignedBy->name }}</p>
                    <p class="text-sm text-gray-500 dark:text-gray-300"><span class="font-medium text-gray-900 dark:text-white">Assigned on:</span> {{ $task->currentAssignment->assigned_at->format('M d, Y H:i') }}</p>
                </div>
                @else
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-600 pb-2">
                    <i class="fas fa-user-times mr-2 text-red-500 dark:text-red-400"></i>Current Assignment
                </h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">No current assignment</p>
                @endif
            </div>
        </div>

        <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">
                    <i class="fas fa-timeline mr-2 text-purple-500 dark:text-purple-400"></i>Assignment Timeline
                </h3>
            </div>
            <div class="p-6">
                <div class="flow-root">
                    <ul class="-mb-8">
                        @forelse($task->assignments->sortBy('assigned_at') as $assignment)
                        <li>
                            <div class="relative pb-8">
                                @if(!$loop->last)
                                <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-200 dark:bg-gray-600" aria-hidden="true"></span>
                                @endif
                                <div class="relative flex space-x-3">
                                    <div>
                                        @if($assignment->status === 'completed')
                                        <span class="h-8 w-8 rounded-full bg-green-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                            <i class="fas fa-check text-white text-xs"></i>
                                        </span>
                                        @elseif($assignment->status === 'active')
                                        <span class="h-8 w-8 rounded-full bg-blue-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                            <i class="fas fa-user text-white text-xs"></i>
                                        </span>
                                        @else
                                        <span class="h-8 w-8 rounded-full bg-gray-400 dark:bg-gray-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                            <i class="fas fa-arrow-right text-white text-xs"></i>
                                        </span>
                                        @endif
                                    </div>
                                    <div class="min-w-0 flex-1">
                                        <div class="bg-white dark:bg-gray-700/50 rounded-lg p-4 border border-gray-200 dark:border-gray-500 shadow-sm">
                                            <div class="flex items-start justify-between">
                                                <div class="flex-1">
                                                    <div class="flex items-center space-x-2 mb-2">
                                                        <span class="text-sm font-medium text-gray-900 dark:text-white">
                                                            <strong>{{ $assignment->assignedBy->name }}</strong> assigned task to 
                                                            <strong>{{ $assignment->assignedTo->name }}</strong>
                                                        </span>
                                                    </div>
                                                    @if($assignment->department)
                                                    <p class="text-xs text-gray-500 dark:text-gray-400 mb-1">Department: {{ $assignment->department->name }}</p>
                                                    @endif
                                                    @if($assignment->notes)
                                                        <p class="text-sm text-gray-600 dark:text-gray-300 italic">"{{ $assignment->notes }}"</p>
                                                    @endif
                                                    <div class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                                                        <span><i class="fas fa-calendar mr-1"></i>{{ $assignment->assigned_at->format('M d, Y H:i') }}</span>
                                                        @if($assignment->completed_at)
                                                            <span class="ml-4 text-green-600 dark:text-green-400"><i class="fas fa-check-circle mr-1"></i>Completed: {{ $assignment->completed_at->format('M d, Y H:i') }}</span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="ml-4">
                                                    @if($assignment->status === 'completed')
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300">
                                                            <i class="fas fa-check mr-1"></i>{{ ucfirst($assignment->status) }}
                                                        </span>
                                                    @elseif($assignment->status === 'active')
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300">
                                                            <i class="fas fa-clock mr-1"></i>{{ ucfirst($assignment->status) }}
                                                        </span>
                                                    @else
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">
                                                            <i class="fas fa-pause mr-1"></i>{{ ucfirst($assignment->status) }}
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                        @empty
                        <li>
                            <div class="text-center py-12">
                                <i class="fas fa-history text-6xl text-gray-300 dark:text-gray-500 mb-4"></i>
                                <h3 class="text-xl font-medium text-gray-900 dark:text-gray-300 mb-2">No assignment history</h3>
                                <p class="text-gray-500 dark:text-gray-400">This task has no assignment history yet.</p>
                            </div>
                        </li>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection