@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Staff Details</h1>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300">View staff member information</p>
                    </div>
                    <div class="flex space-x-3">
                        <a href="{{ route('staff.index') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to List
                        </a>
                        @can('update', $staff)
                            <a href="{{ route('staff.edit', $staff) }}" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-edit mr-2"></i>
                                Edit
                            </a>
                        @endcan
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Staff Information -->
            <div class="lg:col-span-2">
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Personal Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Full Name</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->name }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Email Address</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->email }}</p>
                            </div>
                            @if($staff->staffProfile)
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Employee ID</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->staffProfile->employee_id ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Phone Number</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->staffProfile->phone ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Department</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->staffProfile->department->name ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Position</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->staffProfile->position ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Hire Date</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->staffProfile->hire_date ? $staff->staffProfile->hire_date->format('M j, Y') : 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Salary</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">₹{{ $staff->staffProfile->salary ? number_format($staff->staffProfile->salary, 2) : 'N/A' }}</p>
                            </div>
                            @if($staff->staffProfile->address)
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Address</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white bg-gray-50 dark:bg-gray-900/50 p-3 rounded-md border border-gray-200 dark:border-gray-600">{{ $staff->staffProfile->address }}</p>
                            </div>
                            @endif
                            @endif
                        </div>

                        <!-- Account Information -->
                        <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                            <h4 class="text-md font-medium text-gray-900 dark:text-white mb-4">Account Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Role</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->roles->first()->name ?? 'No Role Assigned' }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Member Since</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->created_at->format('M j, Y') }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Last Updated</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $staff->updated_at->format('M j, Y g:i A') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="space-y-6">
                <!-- Recent Activity -->
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-4">Quick Stats</h3>
                        
                        <div class="space-y-4">
                            <div class="flex items-center justify-between">
                                <span class="text-sm text-gray-500 dark:text-gray-300">Total Tasks</span>
                                <span class="text-sm font-medium text-gray-900 dark:text-white">{{ $staff->assignedTasks->count() }}</span>
                            </div>
                            <div class="flex items-center justify-between">
                                <span class="text-sm text-gray-500 dark:text-gray-300">Completed Tasks</span>
                                <span class="text-sm font-medium text-gray-900 dark:text-white">{{ $staff->assignedTasks->where('status', 'completed')->count() }}</span>
                            </div>
                            <div class="flex items-center justify-between">
                                <span class="text-sm text-gray-500 dark:text-gray-300">Pending Tasks</span>
                                <span class="text-sm font-medium text-gray-900 dark:text-white">{{ $staff->assignedTasks->where('status', 'pending')->count() }}</span>
                            </div>
                            <div class="flex items-center justify-between">
                                <span class="text-sm text-gray-500 dark:text-gray-300">Attendance Records</span>
                                <span class="text-sm font-medium text-gray-900 dark:text-white">{{ $staff->attendances->count() }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-4">Quick Actions</h3>
                        
                        <div class="space-y-3">
                            <a href="{{ route('tasks.create', ['assigned_to' => $staff->id]) }}" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-plus mr-2"></i>
                                Assign Task
                            </a>
                            <a href="{{ route('attendance.create', ['user_id' => $staff->id]) }}" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-calendar-check mr-2"></i>
                                Add Attendance
                            </a>
                            <a href="{{ route('payrolls.create', ['user_id' => $staff->id]) }}" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-money-bill-wave mr-2"></i>
                                Generate Payroll
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
