@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-transparent py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Edit Payroll</h1>
                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-300">{{ $payroll->user->name }} - {{ date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year)) }}</p>
                    </div>
                    <a href="{{ route('payrolls.show', $payroll) }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to Details
                    </a>
                </div>
            </div>
        </div>

        <!-- Error Messages -->
        @if ($errors->any())
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-700 text-red-800 dark:text-red-400 px-4 py-3 rounded-lg mb-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-circle"></i>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium">There were some errors with your submission:</h3>
                        <ul class="mt-2 text-sm list-disc list-inside">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        @endif

        <form action="{{ route('payrolls.update', $payroll) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Form -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Employee Information -->
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Employee Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Employee</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white bg-gray-50 dark:bg-gray-700/50 px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600">{{ $payroll->user->name }}</p>
                                <input type="hidden" name="user_id" value="{{ $payroll->user_id }}">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Employee ID</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white bg-gray-50 dark:bg-gray-700/50 px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600">{{ $payroll->user->staffProfile->employee_id ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Department</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white bg-gray-50 dark:bg-gray-700/50 px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600">{{ $payroll->user->staffProfile->department->name ?? 'No Department' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Position</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white bg-gray-50 dark:bg-gray-700/50 px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600">{{ $payroll->user->staffProfile->position ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                    <!-- Pay Period -->
                    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Pay Period</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="month" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Month</label>
                                    <select name="month" id="month" class="mt-1 block w-full bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                        @for($i = 1; $i <= 12; $i++)
                                            <option value="{{ $i }}" {{ $payroll->month == $i ? 'selected' : '' }}>
                                                {{ date('F', mktime(0, 0, 0, $i, 1)) }}
                                            </option>
                                        @endfor
                                    </select>
                                    @error('month')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div>
                                    <label for="year" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Year</label>
                                    <select name="year" id="year" class="mt-1 block w-full bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                        @for($i = date('Y') - 2; $i <= date('Y') + 1; $i++)
                                            <option value="{{ $i }}" {{ $payroll->year == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                    @error('year')
                                         <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                     @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Work Details -->
                    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Work Details</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="days_worked" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Days Worked</label>
                                    <input type="number" name="days_worked" id="days_worked" min="0" max="31" step="0.5" value="{{ old('days_worked', $payroll->days_worked) }}" class="mt-1 block w-full bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                    @error('days_worked')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div>
                                    <label for="hours_worked" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Hours Worked</label>
                                    <input type="number" name="hours_worked" id="hours_worked" min="0" step="0.5" value="{{ old('hours_worked', $payroll->hours_worked) }}" class="mt-1 block w-full bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                    @error('hours_worked')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Salary Details -->
                    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Salary Structure</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Earnings -->
                                <div class="col-span-2">
                                    <h4 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-4 uppercase tracking-wider">Earnings</h4>
                                </div>
                                
                                <div>
                                    <label for="basic_salary" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Basic Salary</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="basic_salary" id="basic_salary" min="0" step="0.01" value="{{ old('basic_salary', $payroll->basic_salary) }}" class="block w-full pl-7 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('basic_salary')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="hra" class="block text-sm font-medium text-gray-700 dark:text-gray-300">HRA</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="hra" id="hra" min="0" step="0.01" value="{{ old('hra', $payroll->hra) }}" class="block w-full pl-7 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('hra')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="conveyance" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Conveyance</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="conveyance" id="conveyance" min="0" step="0.01" value="{{ old('conveyance', $payroll->conveyance) }}" class="block w-full pl-7 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('conveyance')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="special_allowance" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Special Allowance</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="special_allowance" id="special_allowance" min="0" step="0.01" value="{{ old('special_allowance', $payroll->special_allowance) }}" class="block w-full pl-7 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('special_allowance')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- Employer Contributions -->
                                <div class="col-span-2 mt-4">
                                    <h4 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-4 uppercase tracking-wider">Employer Contributions</h4>
                                </div>
                                
                                <div>
                                    <label for="employer_pf" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Employer PF</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="employer_pf" id="employer_pf" min="0" step="0.01" value="{{ old('employer_pf', $payroll->employer_pf) }}" class="block w-full pl-7 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('employer_pf')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="employer_esi" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Employer ESI</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="employer_esi" id="employer_esi" min="0" step="0.01" value="{{ old('employer_esi', $payroll->employer_esi) }}" class="block w-full pl-7 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('employer_esi')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- Employee Deductions -->
                                <div class="col-span-2 mt-4">
                                    <h4 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-4 uppercase tracking-wider">Employee Deductions</h4>
                                </div>
                                
                                <div>
                                    <label for="employee_pf" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Employee PF</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="employee_pf" id="employee_pf" min="0" step="0.01" value="{{ old('employee_pf', $payroll->employee_pf) }}" class="block w-full pl-7 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('employee_pf')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="employee_esi" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Employee ESI</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="employee_esi" id="employee_esi" min="0" step="0.01" value="{{ old('employee_esi', $payroll->employee_esi) }}" class="block w-full pl-7 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('employee_esi')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="professional_tax" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Professional Tax</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 dark:text-gray-400 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="professional_tax" id="professional_tax" min="0" step="0.01" value="{{ old('professional_tax', $payroll->professional_tax) }}" class="block w-full pl-7 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500 calculation-input">
                                    </div>
                                    @error('professional_tax')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Status -->
                    <div class="bg-white dark:bg-gray-800 shadow rounded-lg border border-gray-200 dark:border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-4">Status</h3>
                            
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Payroll Status</label>
                                <select name="status" id="status" class="mt-1 block w-full bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm py-2 px-3 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                    <option value="pending" {{ $payroll->status === 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="approved" {{ $payroll->status === 'approved' ? 'selected' : '' }}>Approved</option>
                                    <option value="paid" {{ $payroll->status === 'paid' ? 'selected' : '' }}>Paid</option>
                                </select>
                                @error('status')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Calculated Totals -->
                    <div class="bg-white dark:bg-gray-800 shadow rounded-lg border border-gray-200 dark:border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-4">Calculated Totals</h3>
                            
                            <div class="space-y-4">
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600 dark:text-gray-300">Gross Salary:</span>
                                    <span class="text-sm font-medium text-gray-900 dark:text-white" id="gross-total">₹{{ number_format($payroll->gross_salary, 2) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600 dark:text-gray-300">CTC:</span>
                                    <span class="text-sm font-medium text-gray-900 dark:text-white" id="ctc-total">₹{{ number_format($payroll->ctc, 2) }}</span>
                                </div>
                                <div class="flex justify-between border-t border-gray-200 dark:border-gray-700 pt-4">
                                    <span class="text-sm font-medium text-gray-900 dark:text-white">Net Salary:</span>
                                    <span class="text-sm font-bold text-red-600 dark:text-red-400" id="net-total">₹{{ number_format($payroll->net_salary, 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="bg-white dark:bg-gray-800 shadow rounded-lg border border-gray-200 dark:border-gray-700">
                        <div class="px-4 py-5 sm:p-6">
                            <div class="space-y-3">
                                <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                    <i class="fas fa-save mr-2"></i>
                                    Update Payroll
                                </button>
                                <a href="{{ route('payrolls.show', $payroll) }}" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                    <i class="fas fa-times mr-2"></i>
                                    Cancel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    function calculateTotals() {
        // Earnings
        const basic = parseFloat(document.getElementById('basic_salary').value) || 0;
        const hra = parseFloat(document.getElementById('hra').value) || 0;
        const conveyance = parseFloat(document.getElementById('conveyance').value) || 0;
        const special = parseFloat(document.getElementById('special_allowance').value) || 0;
        
        const gross = basic + hra + conveyance + special;
        
        // Employer Contributions
        const empPf = parseFloat(document.getElementById('employer_pf').value) || 0;
        const empEsi = parseFloat(document.getElementById('employer_esi').value) || 0;
        
        const ctc = gross + empPf + empEsi;
        
        // Employee Deductions
        const employeePf = parseFloat(document.getElementById('employee_pf').value) || 0;
        const employeeEsi = parseFloat(document.getElementById('employee_esi').value) || 0;
        const profTax = parseFloat(document.getElementById('professional_tax').value) || 0;
        
        const totalDeductions = employeePf + employeeEsi + profTax;
        
        const net = gross - totalDeductions;
        
        // Update display
        document.getElementById('gross-total').textContent = '₹' + gross.toFixed(2);
        document.getElementById('ctc-total').textContent = '₹' + ctc.toFixed(2);
        document.getElementById('net-total').textContent = '₹' + net.toFixed(2);
    }
    
    // Attach listeners
    const inputs = document.querySelectorAll('.calculation-input');
    inputs.forEach(input => {
        input.addEventListener('input', calculateTotals);
    });
});
</script>
@endsection
