@extends('layouts.app')

@section('content')
<div class="flex-1 p-6 bg-gray-50 dark:bg-gray-900 min-h-screen">
    <div class="max-w-4xl mx-auto">
        <!-- Header Section -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">{{ __('Create Payroll Record') }}</h1>
                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-300">Create a new payroll record for an employee</p>
                    </div>
                    <div class="mt-4 sm:mt-0">
                        <a href="{{ route('payrolls.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-100 dark:bg-gray-600 hover:bg-gray-200 dark:hover:bg-gray-700 text-gray-700 dark:text-white text-sm font-medium rounded-lg transition-colors duration-200">
                            <i class="fas fa-arrow-left mr-2"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
            <div class="p-6">
                    @if ($errors->any())
                        <div class="bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-700 rounded-lg p-4 mb-6">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-exclamation-circle text-red-400"></i>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-red-800 dark:text-red-200">There were errors with your submission</h3>
                                    <div class="mt-2 text-sm text-red-700 dark:text-red-300">
                                        <ul class="list-disc list-inside space-y-1">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('payrolls.store') }}" id="payrollForm" class="space-y-6">
                        @csrf

                        <div>
                            <label for="user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Staff Member') }} <span class="text-red-500">*</span></label>
                            <select id="user_id" class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('user_id') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                    name="user_id" required>
                                <option value="">Select Staff Member</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" 
                                            data-salary="{{ $user->staffProfile->salary ?? 0 }}"
                                            {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                        {{ $user->name }} ({{ $user->staffProfile->employee_id ?? 'N/A' }})
                                    </option>
                                @endforeach
                            </select>
                            @error('user_id')
                                <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="month" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Month') }} <span class="text-red-500">*</span></label>
                                <select id="month" class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('month') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                        name="month" required>
                                    @for($i = 1; $i <= 12; $i++)
                                        <option value="{{ $i }}" {{ old('month', date('n')) == $i ? 'selected' : '' }}>
                                            {{ date('F', mktime(0, 0, 0, $i, 1)) }}
                                        </option>
                                    @endfor
                                </select>
                                @error('month')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="year" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Year') }} <span class="text-red-500">*</span></label>
                                <select id="year" class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('year') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                        name="year" required>
                                    @for($i = 2020; $i <= 2030; $i++)
                                        <option value="{{ $i }}" {{ old('year', date('Y')) == $i ? 'selected' : '' }}>
                                            {{ $i }}
                                        </option>
                                    @endfor
                                </select>
                                @error('year')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="basic_salary" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Basic Salary') }} <span class="text-red-500">*</span></label>
                                <div class="relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 dark:text-gray-400 sm:text-sm">$</span>
                                    </div>
                                    <input type="number" step="0.01" name="basic_salary" id="basic_salary" class="pl-7 block w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent" 
                                           placeholder="0.00" required value="{{ old('basic_salary') }}">
                                </div>
                                @error('basic_salary')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Special Deduction -->
                            <div>
                                <label for="special_deduction" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Special Deduction') }}</label>
                                <div class="relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 dark:text-gray-400 sm:text-sm">$</span>
                                    </div>
                                    <input type="number" step="0.01" name="special_deduction" id="special_deduction" class="pl-7 block w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent" 
                                           placeholder="0.00" value="{{ old('special_deduction') }}">
                                </div>
                                @error('special_deduction')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Special Deduction Note -->
                        <div>
                            <label for="special_deduction_note" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Special Deduction Note') }} <span class="text-xs text-gray-500">(Required if deduction > 0)</span></label>
                            <textarea name="special_deduction_note" id="special_deduction_note" rows="2" class="block w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">{{ old('special_deduction_note') }}</textarea>
                            @error('special_deduction_note')
                                <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                                <label for="allowances" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Allowances') }}</label>
                                <div class="relative">
                                    <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500 dark:text-gray-400">₹</span>
                                    <input id="allowances" type="number" step="0.01" min="0" 
                                           class="w-full pl-8 pr-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('allowances') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                           name="allowances" value="{{ old('allowances', 0) }}">
                                </div>
                                @error('allowances')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="overtime_hours" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Overtime Hours') }}</label>
                                <input id="overtime_hours" type="number" step="0.5" min="0" 
                                       class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('overtime_hours') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                       name="overtime_hours" value="{{ old('overtime_hours', 0) }}" placeholder="0.0">
                                @error('overtime_hours')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="overtime_rate" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Overtime Rate (per hour)') }}</label>
                                <div class="relative">
                                    <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500 dark:text-gray-400">₹</span>
                                    <input id="overtime_rate" type="number" step="0.01" min="0" 
                                           class="w-full pl-8 pr-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('overtime_rate') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                           name="overtime_rate" value="{{ old('overtime_rate', 0) }}" placeholder="0.00">
                                </div>
                                @error('overtime_rate')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="deductions" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Deductions') }}</label>
                                <div class="relative">
                                    <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500 dark:text-gray-400">₹</span>
                                    <input id="deductions" type="number" step="0.01" min="0" 
                                           class="w-full pl-8 pr-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('deductions') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                           name="deductions" value="{{ old('deductions', 0) }}" placeholder="0.00">
                                </div>
                                @error('deductions')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="bonus" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Bonus') }}</label>
                                <div class="relative">
                                    <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500 dark:text-gray-400">₹</span>
                                    <input id="bonus" type="number" step="0.01" min="0" 
                                           class="w-full pl-8 pr-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('bonus') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                           name="bonus" value="{{ old('bonus', 0) }}" placeholder="0.00">
                                </div>
                                @error('bonus')
                                    <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Calculated Amounts -->
                        <div class="bg-gray-50 dark:bg-gray-800/50 backdrop-blur-md rounded-lg border border-gray-200 dark:border-gray-600 p-6">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">{{ __('Calculated Amounts') }}</h3>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-600 dark:text-gray-300 mb-2">{{ __('Overtime Pay') }}</label>
                                    <div class="text-lg font-semibold text-gray-900 dark:text-white" id="overtime_pay_display">₹0.00</div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-600 dark:text-gray-300 mb-2">{{ __('Gross Salary') }}</label>
                                    <div class="text-lg font-semibold text-gray-900 dark:text-red-400" id="gross_salary_display">₹0.00</div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-600 dark:text-gray-300 mb-2">{{ __('Net Salary') }}</label>
                                    <div class="text-lg font-semibold text-gray-900 dark:text-red-400" id="net_salary_display">₹0.00</div>
                                </div>
                            </div>
                        </div>

                        <div>
                            <label for="notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Notes') }}</label>
                            <textarea id="notes" class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 @error('notes') border-red-300 focus:ring-red-500 focus:border-red-500 @enderror" 
                                      name="notes" rows="3" placeholder="Optional notes about this payroll">{{ old('notes') }}</textarea>
                            @error('notes')
                                <p class="mt-1 text-sm text-red-500 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex flex-col sm:flex-row sm:justify-end gap-3 pt-6 border-t border-gray-200 dark:border-gray-600">
                            <a href="{{ route('payrolls.index') }}" class="inline-flex items-center justify-center px-4 py-2 bg-gray-100 dark:bg-gray-600 hover:bg-gray-200 dark:hover:bg-gray-700 text-gray-700 dark:text-white text-sm font-medium rounded-lg transition-colors duration-200">
                                <i class="fas fa-times mr-2"></i> Cancel
                            </a>
                            <button type="submit" class="inline-flex items-center justify-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors duration-200">
                                <i class="fas fa-save mr-2"></i> Create Payroll
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const basicSalary = document.getElementById('basic_salary');
        const allowances = document.getElementById('allowances');
        const overtimeHours = document.getElementById('overtime_hours');
        const overtimeRate = document.getElementById('overtime_rate');
        const deductions = document.getElementById('deductions');
        const bonus = document.getElementById('bonus');
        
        const overtimePayDisplay = document.getElementById('overtime_pay_display');
        const grossSalaryDisplay = document.getElementById('gross_salary_display');
        const netSalaryDisplay = document.getElementById('net_salary_display');

        function calculateAmounts() {
            const basic = parseFloat(basicSalary.value) || 0;
            const allow = parseFloat(allowances.value) || 0;
            const hours = parseFloat(overtimeHours.value) || 0;
            const rate = parseFloat(overtimeRate.value) || 0;
            const deduct = parseFloat(deductions.value) || 0;
            const bonusAmount = parseFloat(bonus.value) || 0;

            const overtimePay = hours * rate;
            const grossSalary = basic + allow + overtimePay + bonusAmount;
            const netSalary = grossSalary - deduct;

            overtimePayDisplay.textContent = '₹' + overtimePay.toFixed(2);
            grossSalaryDisplay.textContent = '₹' + grossSalary.toFixed(2);
            netSalaryDisplay.textContent = '₹' + netSalary.toFixed(2);
        }

        // Add event listeners
        [basicSalary, allowances, overtimeHours, overtimeRate, deductions, bonus].forEach(input => {
            input.addEventListener('input', calculateAmounts);
        });

        // Initial calculation
        calculateAmounts();
    });
</script>
@endsection
