@extends('layouts.app')

@section('title', 'Dashboard - Staff Management System')
@section('page-title', 'Dashboard')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
        <div class="px-6 py-4 border-b border-gray-700">
            <h3 class="text-lg font-medium text-white">{{ __('Dashboard') }}</h3>
        </div>
        
        <div class="p-6">
            @if (session('status'))
                <div class="mb-4 bg-blue-900 border border-blue-700 text-blue-300 px-4 py-3 rounded-md">
                    <i class="fas fa-check-circle mr-2"></i>{{ session('status') }}
                </div>
            @endif

            <div class="text-center py-8">
                <div class="mb-4">
                    <i class="fas fa-check-circle text-4xl text-blue-400"></i>
                </div>
                <h2 class="text-xl font-semibold text-white mb-2">{{ __('Welcome to Staff Management System') }}</h2>
                <p class="text-gray-400">{{ __('You are successfully logged in!') }}</p>
            </div>
        </div>
    </div>
</div>
@endsection
