@extends('layouts.app')

@section('title', 'Staff Dashboard - Staff Management System')
@section('page-title', 'My Dashboard')

@section('content')
<div class="space-y-6">
    <!-- Task Priority Section -->
    <div class="bg-gradient-to-r from-red-600 to-orange-700 dark:from-gray-800/50 dark:to-gray-800/50 dark:bg-gray-800/50 dark:backdrop-blur-md shadow-xl rounded-lg border border-red-500 dark:border-gray-700 transition-all duration-300">
        <div class="px-6 py-8">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-white dark:text-white mb-2">Welcome back, {{ Auth::user()->name }}!</h1>
                    <p class="text-red-100 dark:text-gray-300">Department: <span class="font-semibold">{{ $stats['department'] }}</span></p>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('tasks.index') }}" class="inline-flex items-center px-4 py-2 bg-white dark:bg-gray-700 text-red-600 dark:text-white font-semibold rounded-lg hover:bg-red-50 dark:hover:bg-gray-600 transition-colors shadow-sm">
                        <i class="fas fa-list mr-2"></i>
                        All Tasks
                    </a>
                </div>
            </div>
            
            <!-- Task Stats -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-white bg-opacity-10 dark:bg-gray-700/50 backdrop-blur-sm rounded-lg p-4 border border-white/10 dark:border-gray-600">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-tasks text-3xl text-yellow-300 dark:text-yellow-400"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-red-100 dark:text-gray-400 text-sm font-medium">Assigned Tasks</p>
                            <p class="text-white dark:text-white text-2xl font-bold">{{ $stats['assigned_tasks'] }}</p>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white bg-opacity-10 dark:bg-gray-700/50 backdrop-blur-sm rounded-lg p-4 border border-white/10 dark:border-gray-600">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-check-circle text-3xl text-green-300 dark:text-green-400"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-red-100 dark:text-gray-400 text-sm font-medium">Completed Tasks</p>
                            <p class="text-white dark:text-white text-2xl font-bold">{{ $stats['completed_tasks'] }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- My Tasks (Expanded) -->
    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow-xl rounded-lg border border-gray-200 dark:border-gray-700">
        <div class="px-6 py-5">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">My Tasks</h3>
                <a href="{{ route('tasks.index') }}" class="text-sm text-red-600 dark:text-red-400 hover:text-red-500 dark:hover:text-red-300 font-medium">View all tasks →</a>
            </div>
            <div class="space-y-4">
                @forelse($my_tasks as $task)
                    <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-gray-700 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-600 transition-colors">
                        <div class="flex-1">
                            <h4 class="text-base font-medium text-gray-900 dark:text-white mb-1">{{ $task->title }}</h4>
                            @if($task->description)
                                <p class="text-sm text-gray-600 dark:text-gray-300 mb-2">{{ Str::limit($task->description, 80) }}</p>
                            @endif
                            <div class="flex items-center space-x-4 text-xs text-gray-500 dark:text-gray-400">
                                <span><i class="fas fa-user mr-1"></i>{{ $task->creator->name }}</span>
                                <span><i class="fas fa-building mr-1"></i>{{ $task->currentDepartment->name }}</span>
                                <span><i class="fas fa-calendar mr-1"></i>{{ $task->created_at->diffForHumans() }}</span>
                            </div>
                        </div>
                        <div class="flex items-center space-x-3">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                                @if($task->status === 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300
                                @elseif($task->status === 'in_progress') bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300
                                @else bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300 @endif">
                                {{ ucfirst(str_replace('_', ' ', $task->status)) }}
                            </span>
                            @if($task->status !== 'completed')
                                <a href="{{ route('tasks.show', $task) }}" class="text-red-600 dark:text-red-400 hover:text-red-500 dark:hover:text-red-300">
                                    <i class="fas fa-arrow-right"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="text-center py-8">
                        <i class="fas fa-tasks text-4xl text-gray-400 dark:text-gray-600 mb-4"></i>
                        <p class="text-gray-500 dark:text-gray-400 text-lg">No tasks assigned yet</p>
                        <p class="text-gray-400 dark:text-gray-500 text-sm">Check back later for new assignments</p>
                    </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-red-100 dark:bg-red-900/20 rounded-lg">
                        <i class="fas fa-calendar-check text-2xl text-red-500 dark:text-red-400"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Days Present</dt>
                            <dd class="text-lg font-medium text-gray-900 dark:text-white">{{ $stats['attendance_this_month'] }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 p-3 bg-red-100 dark:bg-red-900/20 rounded-lg">
                        <i class="fas fa-building text-2xl text-red-500 dark:text-red-400"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Department</dt>
                            <dd class="text-sm font-medium text-gray-900 dark:text-white">{{ $stats['department'] }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-1 gap-6">

        <!-- Recent Attendance -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Recent Attendance</h3>
                    <a href="{{ route('attendance.staff') }}" class="text-sm text-red-600 dark:text-red-400 hover:text-red-500 dark:hover:text-red-300">View all</a>
                </div>
                <div class="space-y-3">
                    @forelse($recent_attendance as $attendance)
                        <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                            <div>
                                <p class="text-sm font-medium text-gray-900 dark:text-white">{{ $attendance->date->format('M d, Y') }}</p>
                                <p class="text-xs text-gray-500 dark:text-gray-400">{{ $attendance->date->format('l') }}</p>
                            </div>
                            <div>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                    @if($attendance->status === 'present') bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300
                                    @else bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300 @endif">
                                    <i class="fas fa-{{ $attendance->status === 'present' ? 'check' : 'times' }} mr-1"></i>
                                    {{ ucfirst($attendance->status) }}
                                </span>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-8">
                            <i class="fas fa-calendar-check text-4xl text-gray-400 dark:text-gray-500 mb-4"></i>
                            <p class="text-sm text-gray-500 dark:text-gray-400">No attendance records yet</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
        <div class="px-4 py-5 sm:p-6">
            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white mb-4">Quick Actions</h3>
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                <a href="{{ route('tasks.index') }}" class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                    <i class="fas fa-tasks mr-2"></i>
                    View My Tasks
                </a>
                <a href="{{ route('attendance.staff') }}" class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                    <i class="fas fa-calendar-alt mr-2"></i>
                    View Attendance
                </a>
            </div>
        </div>
    </div>
</div>

@endsection