@extends('layouts.app')

@section('page-title', 'Confirm Password')

@section('content')
<div class="max-w-md mx-auto">
    <div class="bg-gray-800 rounded-lg shadow-xl border border-gray-700">
        <div class="px-6 py-4 border-b border-gray-700">
            <h1 class="text-xl font-bold text-white">
                <i class="fas fa-shield-alt mr-3 text-red-400"></i>
                {{ __('Confirm Password') }}
            </h1>
        </div>

        <div class="p-6">
            <p class="text-gray-300 mb-6">
                {{ __('Please confirm your password before continuing.') }}
            </p>

            <form method="POST" action="{{ route('password.confirm') }}" class="space-y-6">
                @csrf

                <div>
                    <label for="password" class="block text-sm font-medium text-red-200 mb-2">{{ __('Password') }}</label>
                    <input id="password" type="password" name="password" required autocomplete="current-password"
                           class="w-full px-4 py-3 bg-gray-800 border border-gray-700 rounded-xl text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent @error('password') border-red-500 @enderror"
                           placeholder="Enter your password">
                    @error('password')
                        <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="space-y-3">
                    <button type="submit" class="w-full px-4 py-3 bg-gradient-to-r from-red-600 to-red-600 hover:from-red-700 hover:to-red-700 text-white font-semibold rounded-xl shadow-lg transition-all duration-200 transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 focus:ring-offset-gray-800">
                        <i class="fas fa-check mr-2"></i>
                        {{ __('Confirm Password') }}
                    </button>


                </div>
            </form>
        </div>
    </div>
</div>
@endsection
