@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-transparent py-6">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">My Attendance</h1>
            <p class="text-gray-500 dark:text-gray-400 mt-1">View your attendance calendar for {{ now()->format('F Y') }}</p>
        </div>

        <!-- Calendar -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md rounded-lg shadow-lg overflow-hidden border border-gray-200 dark:border-gray-700">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Attendance Calendar</h2>
            </div>
            
            <div class="p-6">
                <!-- Calendar Grid -->
                <div class="grid grid-cols-7 gap-1 mb-4">
                    <!-- Day Headers -->
                    <div class="text-center py-2 text-sm font-medium text-gray-500 dark:text-gray-300">Sun</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-500 dark:text-gray-300">Mon</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-500 dark:text-gray-300">Tue</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-500 dark:text-gray-300">Wed</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-500 dark:text-gray-300">Thu</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-500 dark:text-gray-300">Fri</div>
                    <div class="text-center py-2 text-sm font-medium text-gray-500 dark:text-gray-300">Sat</div>
                </div>

                <div class="grid grid-cols-7 gap-1">
                    @php
                        $startOfMonth = now()->startOfMonth();
                        $endOfMonth = now()->endOfMonth();
                        $startDate = $startOfMonth->copy()->startOfWeek();
                        $endDate = $endOfMonth->copy()->endOfWeek();
                        $currentDate = $startDate->copy();
                        
                        // Create attendance lookup array
                        $attendanceByDate = $attendances->keyBy(function($item) {
                            return $item->date->format('Y-m-d');
                        });
                    @endphp

                    @while($currentDate <= $endDate)
                        @php
                            $dateKey = $currentDate->format('Y-m-d');
                            $attendance = $attendanceByDate->get($dateKey);
                            $isCurrentMonth = $currentDate->month === now()->month;
                            $isToday = $currentDate->isToday();
                        @endphp
                        
                        <div class="relative h-16 border border-gray-200 dark:border-gray-700 rounded {{ $isCurrentMonth ? 'bg-white dark:bg-gray-700' : 'bg-gray-50 dark:bg-gray-800' }} {{ $isToday ? 'ring-2 ring-red-500' : '' }}">
                            <!-- Date Number -->
                            <div class="absolute top-1 left-1 text-xs {{ $isCurrentMonth ? 'text-gray-900 dark:text-white' : 'text-gray-400 dark:text-gray-500' }}">
                                {{ $currentDate->day }}
                            </div>
                            
                            @if($isCurrentMonth && $attendance)
                                <!-- Attendance Status -->
                                <div class="absolute bottom-1 left-1 right-1">
                                    @if($attendance->status === 'present')
                                        <div class="w-full h-2 bg-green-500 rounded-sm" title="Present"></div>
                                    @elseif($attendance->status === 'late')
                                        <div class="w-full h-2 bg-yellow-500 rounded-sm" title="Late"></div>
                                    @elseif($attendance->status === 'absent')
                                        <div class="w-full h-2 bg-red-500 rounded-sm" title="Absent"></div>
                                    @elseif($attendance->status === 'half_day')
                                        <div class="w-full h-2 bg-orange-500 rounded-sm" title="Half Day"></div>
                                    @endif
                                </div>
                                
                                <!-- Status Icon -->
                                <div class="absolute top-1 right-1">
                                    @if($attendance->status === 'present')
                                        <i class="fas fa-check text-green-500 dark:text-green-400 text-xs"></i>
                                    @elseif($attendance->status === 'late')
                                        <i class="fas fa-clock text-yellow-500 dark:text-yellow-400 text-xs"></i>
                                    @elseif($attendance->status === 'absent')
                                        <i class="fas fa-times text-red-500 dark:text-red-400 text-xs"></i>
                                    @elseif($attendance->status === 'half_day')
                                        <i class="fas fa-adjust text-orange-500 dark:text-orange-400 text-xs"></i>
                                    @endif
                                </div>
                            @endif
                        </div>
                        
                        @php
                            $currentDate->addDay();
                        @endphp
                    @endwhile
                </div>
                
                <!-- Legend -->
                <div class="mt-6 flex flex-wrap gap-4 justify-center">
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-green-500 rounded-sm"></div>
                        <span class="text-sm text-gray-600 dark:text-gray-300">Present</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-yellow-500 rounded-sm"></div>
                        <span class="text-sm text-gray-600 dark:text-gray-300">Late</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-red-500 rounded-sm"></div>
                        <span class="text-sm text-gray-600 dark:text-gray-300">Absent</span>
                    </div>
                    <div class="flex items-center space-x-2">
                        <div class="w-4 h-2 bg-orange-500 rounded-sm"></div>
                        <span class="text-sm text-gray-600 dark:text-gray-300">Half Day</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection