<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Department;

class DepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $departments = [
            [
                'name' => 'Human Resources',
                'description' => 'Manages employee relations, recruitment, and HR policies.'
            ],
            [
                'name' => 'Information Technology',
                'description' => 'Handles all technology infrastructure and software development.'
            ],
            [
                'name' => 'Finance',
                'description' => 'Manages financial planning, accounting, and budgeting.'
            ],
            [
                'name' => 'Marketing',
                'description' => 'Responsible for marketing campaigns and brand management.'
            ],
            [
                'name' => 'Operations',
                'description' => 'Oversees daily operations and process optimization.'
            ],
            [
                'name' => 'Sales',
                'description' => 'Manages customer relationships and revenue generation.'
            ],
            [
                'name' => 'Customer Service',
                'description' => 'Handles customer support and satisfaction initiatives.'
            ],
            [
                'name' => 'Legal',
                'description' => 'Manages legal compliance, contracts, and regulatory matters.'
            ],
            [
                'name' => 'Research & Development',
                'description' => 'Focuses on innovation, product development, and research initiatives.'
            ],
            [
                'name' => 'Quality Assurance',
                'description' => 'Ensures product and service quality standards are met.'
            ],
            [
                'name' => 'Procurement',
                'description' => 'Manages vendor relationships and purchasing processes.'
            ],
            [
                'name' => 'Administration',
                'description' => 'Handles general administrative tasks and office management.'
            ],
            [
                'name' => 'Security',
                'description' => 'Manages physical and information security protocols.'
            ],
            [
                'name' => 'Training & Development',
                'description' => 'Oversees employee training programs and professional development.'
            ],
            [
                'name' => 'Public Relations',
                'description' => 'Manages external communications and company reputation.'
            ],
        ];

        foreach ($departments as $department) {
            Department::firstOrCreate(
                ['name' => $department['name']],
                $department
            );
        }
    }
}
