<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Department;
use App\Models\StaffProfile;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            RoleSeeder::class,
            DepartmentSeeder::class,
        ]);

        // Create Admin user
        $admin = User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('password'),
            ]
        );
        $admin->assignRole('Admin');

        // Create Staff users
        $itDept = Department::where('name', 'Information Technology')->first();
        $hrDept = Department::where('name', 'Human Resources')->first();
        $financeDept = Department::where('name', 'Finance')->first();

        $staff1 = User::firstOrCreate(
            ['email' => 'john@example.com'],
            [
                'name' => 'John Doe',
                'password' => Hash::make('password'),
            ]
        );
        $staff1->assignRole('Staff');
        StaffProfile::firstOrCreate(
            ['user_id' => $staff1->id],
            [
                'department_id' => $itDept->id,
                'work_days_per_week' => 5,
                'monthly_compensation' => 5000.00,
            ]
        );

        $staff2 = User::firstOrCreate(
            ['email' => 'jane@example.com'],
            [
                'name' => 'Jane Smith',
                'password' => Hash::make('password'),
            ]
        );
        $staff2->assignRole('Staff');
        StaffProfile::firstOrCreate(
            ['user_id' => $staff2->id],
            [
                'department_id' => $hrDept->id,
                'work_days_per_week' => 5,
                'monthly_compensation' => 4500.00,
            ]
        );

        $staff3 = User::firstOrCreate(
            ['email' => 'mike@example.com'],
            [
                'name' => 'Mike Johnson',
                'password' => Hash::make('password'),
            ]
        );
        $staff3->assignRole('Staff');
        StaffProfile::firstOrCreate(
            ['user_id' => $staff3->id],
            [
                'department_id' => $financeDept->id,
                'work_days_per_week' => 5,
                'monthly_compensation' => 5500.00,
            ]
        );
    }
}
