<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            $table->decimal('special_deduction', 10, 2)->default(0)->after('paid_leave_days');
            $table->string('special_deduction_note')->nullable()->after('special_deduction');
            $table->decimal('reimbursement_total', 10, 2)->default(0)->after('special_deduction_note');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            $table->dropColumn(['special_deduction', 'special_deduction_note', 'reimbursement_total']);
        });
    }
};
