<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            $table->string('selfie_path')->nullable()->after('notes');
            $table->decimal('latitude', 10, 8)->nullable()->after('selfie_path');
            $table->decimal('longitude', 11, 8)->nullable()->after('latitude');
            $table->string('location_address')->nullable()->after('longitude');
            $table->json('device_info')->nullable()->after('location_address');
            $table->timestamp('marked_at')->nullable()->after('device_info');
            $table->enum('attendance_type', ['manual', 'admin', 'check-in'])->default('admin')->after('marked_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            $table->dropColumn([
                'selfie_path',
                'latitude',
                'longitude', 
                'location_address',
                'device_info',
                'marked_at',
                'attendance_type'
            ]);
        });
    }
};
