<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            $table->enum('payroll_type', ['individual', 'bulk'])->default('individual')->after('user_id');
            $table->string('batch_id')->nullable()->after('payroll_type');
            $table->index(['payroll_type', 'batch_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            $table->dropIndex(['payroll_type', 'batch_id']);
            $table->dropColumn(['payroll_type', 'batch_id']);
        });
    }
};
