<?php

namespace App\Providers;

use App\Models\User;
use App\Models\Task;
use App\Models\Attendance;
use App\Models\Payroll;
use App\Policies\UserPolicy;
use App\Policies\TaskPolicy;
use App\Policies\AttendancePolicy;
use App\Policies\PayrollPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        User::class => UserPolicy::class,
        Task::class => TaskPolicy::class,
        Attendance::class => AttendancePolicy::class,
        Payroll::class => PayrollPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        //
    }
}