<?php

namespace App\Policies;

use App\Models\Task;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TaskPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user)
    {
        return true; // Both Admin and Staff can view tasks
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Task $task)
    {
        return true; // Both Admin and Staff can view individual tasks
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user)
    {
        return $user->hasRole('Admin') || $user->hasRole('Super Admin'); // Admin and Super Admin can create tasks
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Task $task)
    {
        return $user->hasRole('Admin') || $user->hasRole('Super Admin'); // Admin and Super Admin can update tasks
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Task $task)
    {
        return $user->hasRole('Admin') || $user->hasRole('Super Admin'); // Admin and Super Admin can delete tasks
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Task $task)
    {
        return $user->hasRole('Admin') || $user->hasRole('Super Admin');
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Task $task)
    {
        return $user->hasRole('Admin') || $user->hasRole('Super Admin');
    }

    /**
     * Determine whether the user can complete the task.
     * Only Super Admin can mark tasks as completed.
     */
    public function complete(User $user, Task $task)
    {
        return $user->hasRole('Super Admin');
    }

    /**
     * Determine whether the user can reassign the task.
     * Super Admin, Admin, or the currently assigned user can reassign.
     */
    public function reassign(User $user, Task $task)
    {
        return $user->hasRole('Super Admin') || 
               $user->hasRole('Admin') || 
               $task->current_assigned_to === $user->id;
    }

    /**
     * Determine whether the user can view assignment history.
     */
    public function viewAssignmentHistory(User $user, Task $task)
    {
        return $user->hasRole('Super Admin') || $user->hasRole('Admin');
    }
}