<?php

namespace App\Policies;

use App\Models\Payroll;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class PayrollPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user)
    {
        // Admin can view all payroll records
        // Staff can view their own payroll records (handled in controller)
        return $user->hasRole('Admin') || $user->hasRole('Staff');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Payroll $payroll)
    {
        // Admin can view any payroll record
        if ($user->hasRole('Admin')) {
            return true;
        }
        
        // Staff can only view their own payroll records
        return $user->hasRole('Staff') && $payroll->user_id === $user->id;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user)
    {
        // Only Admin can create payroll records
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Payroll $payroll)
    {
        // Only Admin can update payroll records
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Payroll $payroll)
    {
        // Only Admin can delete payroll records
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Payroll $payroll)
    {
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Payroll $payroll)
    {
        return $user->hasRole('Admin');
    }
}