<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Stock extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     */
    protected $table = 'stock_inventory';

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'product',
        'style',
        'color',
        'size',
        'batch_no',
        'current_balance_qty',
        'uploaded_by',
        'uploaded_at',
    ];

    /**
     * The attributes that should be cast.
     */
    protected $casts = [
        'batch_no' => 'integer',
        'current_balance_qty' => 'integer',
        'uploaded_at' => 'datetime',
    ];

    /**
     * Scope to filter by name
     */
    public function scopeFilterByName($query, $name)
    {
        return $query->where('name', 'like', '%' . $name . '%');
    }

    /**
     * Scope to filter by product
     */
    public function scopeFilterByProduct($query, $product)
    {
        return $query->where('product', 'like', '%' . $product . '%');
    }

    /**
     * Scope to filter by style
     */
    public function scopeFilterByStyle($query, $style)
    {
        return $query->where('style', 'like', '%' . $style . '%');
    }

    /**
     * Scope to filter by color
     */
    public function scopeFilterByColor($query, $color)
    {
        return $query->where('color', 'like', '%' . $color . '%');
    }

    /**
     * Scope to filter by size
     */
    public function scopeFilterBySize($query, $size)
    {
        return $query->where('size', 'like', '%' . $size . '%');
    }

    /**
     * Scope to filter by batch number
     */
    public function scopeFilterByBatchNo($query, $batchNo)
    {
        return $query->where('batch_no', $batchNo);
    }

    /**
     * Get unique values for filter dropdowns
     */
    public static function getUniqueNames()
    {
        return self::distinct()->pluck('name')->sort()->values();
    }

    public static function getUniqueProducts()
    {
        return self::distinct()->pluck('product')->sort()->values();
    }

    public static function getUniqueStyles()
    {
        return self::distinct()->pluck('style')->sort()->values();
    }

    public static function getUniqueColors()
    {
        return self::distinct()->pluck('color')->sort()->values();
    }

    public static function getUniqueSizes()
    {
        return self::distinct()->pluck('size')->sort()->values();
    }

    public static function getUniqueBatchNos()
    {
        return self::distinct()->pluck('batch_no')->sort()->values();
    }
}
